/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Numbers {
    private Numbers() {
    }

    public static int intValue(@Nullable Number number) {
        return Numbers.intValue(number, 0);
    }

    public static int intValue(@Nullable Number number, int defaultValue) {
        return number != null ? number.intValue() : defaultValue;
    }

    public static long longValue(@Nullable Number number) {
        return Numbers.longValue(number, 0L);
    }

    public static long longValue(@Nullable Number number, long defaultValue) {
        return number != null ? number.longValue() : defaultValue;
    }

    public static double doubleValue(@Nullable Number number) {
        return Numbers.doubleValue(number, 0.0);
    }

    public static double doubleValue(@Nullable Number number, double defaultValue) {
        return number != null ? number.doubleValue() : defaultValue;
    }

    @CheckForNull
    public static Integer toInteger(@Nullable Number number) {
        if (number == null || number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    @Nonnull
    public static BigDecimal toBigDecimal(String numberValue) {
        MathContext mc = new MathContext(numberValue.trim().length(), RoundingMode.HALF_EVEN);
        return new BigDecimal(numberValue.trim(), mc);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return Numbers.toBigDecimal(Double.valueOf(number.doubleValue()).toString());
    }

    public static int longToInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static int sumInt(Iterable<? extends Number> numbers) {
        int result = 0;
        for (Number number : numbers) {
            result += Numbers.intValue(number);
        }
        return result;
    }
}

