/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Maps2 {
    @Nonnull
    public static <K, V> ImmutableMap<K, V> onlyPresentValues(Map<? extends K, ? extends Optional<? extends V>> map) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<K, Optional<V>> entry : map.entrySet()) {
            K k = entry.getKey();
            Optional<? extends V> ov = entry.getValue();
            if (k == null || ov == null || !ov.isPresent()) continue;
            result.put(k, ov.get());
        }
        return result.build();
    }

    @Nonnull
    public static <K, V> Map<K, V> filterValues(Map<K, ?> unfiltered, Class<V> type) {
        return Maps.filterValues(unfiltered, (Predicate)Predicates.instanceOf(type));
    }

    @Nonnull
    public static <K, V> Map<K, V> filterKeys(Map<?, V> unfiltered, Class<K> type) {
        return Maps.filterKeys(unfiltered, (Predicate)Predicates.instanceOf(type));
    }

    @SafeVarargs
    @Nonnull
    public static <K, V> ImmutableMap<K, V> join(Map<? extends K, ? extends V> ... ms) {
        return Maps2.join(Iterators.forArray((Object[])ms));
    }

    @Nonnull
    public static <K, V> ImmutableMap<K, V> join(Iterable<? extends Map<? extends K, ? extends V>> ms) {
        return Maps2.join(ms.iterator());
    }

    @Nonnull
    public static <K, V> ImmutableMap<K, V> join(Iterator<? extends Map<? extends K, ? extends V>> ms) {
        HashSet s = new HashSet();
        ImmutableMap.Builder result = ImmutableMap.builder();
        ms.forEachRemaining(m -> m.entrySet().forEach(e -> {
            Object key = e.getKey();
            if (s.add(key)) {
                result.put(key, e.getValue());
            }
        }));
        return result.build();
    }

    @Nonnull
    public static <K, V> Collector<V, ?, ImmutableMap<K, V>> toMap(Function<? super V, ? extends K> keyFunction) {
        return ImmutableMap.toImmutableMap(keyFunction, (Function)Functions.identity());
    }
}

