/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.util.AbstractTokenUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HistoryTokenParser {
    private static final int EOF = -1;
    private final AbstractTokenUtil _tokenUtil;
    private ArrayList<TokenParam> _params = new ArrayList();
    private HistoryToken _historyToken = null;
    private String _hash = null;
    private String _token;
    private int _curPos;
    private int _len;
    private StringBuilder _currentString;

    public HistoryTokenParser(AbstractTokenUtil tokenUtil) {
        this._tokenUtil = tokenUtil;
    }

    @Nonnull
    private HistoryTokenParser parseHistoryToken() throws TokenUtil.TokenParseException {
        int ch;
        this.clearCurrentString();
        while ((ch = this.nextChar()) != -1) {
            switch (ch) {
                case 46: {
                    this.storeHistoryToken();
                    return this.parseParams();
                }
                case 35: {
                    this.storeHistoryToken();
                    return this.parseHash();
                }
            }
            this.appendToCurrentString(ch);
        }
        this.storeHistoryToken();
        return this;
    }

    private void storeHistoryToken() {
        this._historyToken = HistoryToken.fromString(this._currentString.toString());
        this.clearCurrentString();
    }

    private int nextChar() {
        if (this._curPos >= this._len) {
            return -1;
        }
        return this._token.charAt(this._curPos++);
    }

    @Nonnull
    private HistoryTokenParser parseParams() throws TokenUtil.TokenParseException {
        int ch;
        this.clearCurrentString();
        block4: while ((ch = this.nextChar()) != -1) {
            switch (ch) {
                case 46: {
                    this.addParam();
                    continue block4;
                }
                case 35: {
                    this.addParam();
                    return this.parseHash();
                }
            }
            this.appendToCurrentString(ch);
        }
        this.addParam();
        return this;
    }

    private void appendToCurrentString(int ch) {
        this._currentString.append((char)ch);
    }

    private void clearCurrentString() {
        this._currentString = new StringBuilder();
    }

    @Nonnull
    private HistoryTokenParser parseHash() {
        this._hash = this._token.substring(this._curPos);
        return this;
    }

    private void addParam() {
        this._params.add(new TokenParam(this._currentString.toString()));
        this.clearCurrentString();
    }

    @Nonnull
    public HistoryTokenParser parse(String token) throws TokenUtil.TokenParseException {
        this._params = new ArrayList();
        this._historyToken = null;
        this._hash = null;
        this._token = token;
        this._curPos = 0;
        this._len = this._token.length();
        this.skipChar('#');
        this.skipChar('/');
        this.skipChar('!');
        return this.parseHistoryToken();
    }

    private void skipChar(char ch) {
        int nextChar = this.nextChar();
        if (nextChar != ch && nextChar != -1) {
            --this._curPos;
        }
    }

    @CheckForNull
    public HistoryToken getToken() {
        return this._historyToken;
    }

    @Nonnull
    public List<TokenParam> getParams() {
        return this._params;
    }

    @CheckForNull
    public String getHash() {
        return this._hash;
    }

    @Nonnull
    public TokenUtil.TokenIdAndParams resolveTypedParams(String tokenTypes, @Nullable Object[] defaultParams) throws TokenUtil.TokenParseException {
        int definedParamCount = tokenTypes.length();
        List<TokenParam> parsedParams = this.getParams();
        int currentParamCount = parsedParams.size();
        if (currentParamCount > definedParamCount) {
            this._tokenUtil.logWarn(this, "Expected " + definedParamCount + " parameters, but got " + currentParamCount + " parameters. Ignoring additional parameter...");
        }
        if (defaultParams == null && definedParamCount > currentParamCount) {
            throw new TokenUtil.TokenParseException("Only got " + currentParamCount + " parameters, but expected " + definedParamCount + " (and no default parameters exist)");
        }
        ArrayList params = Lists.newArrayListWithCapacity((int)currentParamCount);
        for (int i = 0; i < definedParamCount; ++i) {
            Object p;
            if (i < currentParamCount) {
                TokenParam tokenParam = parsedParams.get(i);
                switch (tokenTypes.charAt(i)) {
                    case 'L': {
                        p = tokenParam.asLong();
                        break;
                    }
                    case 'B': {
                        p = tokenParam.asBoolean();
                        break;
                    }
                    case 'S': {
                        p = tokenParam.asString();
                        break;
                    }
                    default: {
                        throw new TokenUtil.TokenParseException("Unknown type identifier: " + tokenTypes.charAt(i));
                    }
                }
            } else {
                p = defaultParams != null ? defaultParams[i] : null;
            }
            params.add(p);
        }
        return new TokenUtil.TokenIdAndParams(this._historyToken, params, this._hash);
    }

    public final class TokenParam {
        private final String _value;

        private TokenParam(String value) {
            this._value = value;
        }

        @Nonnull
        public String asString() {
            return HistoryTokenParser.this._tokenUtil.decodeURL(this._value);
        }

        public boolean asBoolean() {
            return "t".equals(this._value);
        }

        @CheckForNull
        public Long asLong() {
            return "00".equals(this._value) ? null : Long.valueOf(this._value);
        }
    }
}

