/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.TimePeriod;
import de.justsoftware.onx.common.shared.model.TimeZone;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Dates {
    private static final String LONG_DASH = " \u2013 ";
    private static final long MILLIS_IN_A_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long MILLIS_PER_MINUTE = TimeUnit.MINUTES.toMillis(1L);

    public static Date clone(Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    @CheckForNull
    public static DateWithoutTimezone clone(@Nullable DateWithoutTimezone date) {
        return date != null ? new DateWithoutTimezone(date.getTime()) : null;
    }

    @Nonnull
    public static Date max(@Nonnull Date a, @Nonnull Date b) {
        return a.after(b) ? a : b;
    }

    public static boolean areOnTheSameDay(@Nonnull Date dateOne, @Nonnull Date dateTwo) {
        return dateOne.getDate() == dateTwo.getDate() && dateOne.getMonth() == dateTwo.getMonth() && dateOne.getYear() == dateTwo.getYear();
    }

    public static boolean areOnTheSameMonth(@Nonnull Date dateOne, @Nonnull Date dateTwo) {
        return dateOne.getYear() == dateTwo.getYear() && dateOne.getMonth() == dateTwo.getMonth();
    }

    public static boolean areOnTheSameYear(@Nonnull Date dateOne, @Nonnull Date dateTwo) {
        return dateOne.getYear() == dateTwo.getYear();
    }

    public static int differenceInDays(@Nonnull Date endDate, @Nonnull Date startDate) {
        int difference = 0;
        if (!Dates.areOnTheSameDay(endDate, startDate)) {
            int endDateOffset = endDate.getTimezoneOffset() * 60 * 1000;
            long endDateInstant = endDate.getTime() - (long)endDateOffset;
            int startDateOffset = startDate.getTimezoneOffset() * 60 * 1000;
            long startDateInstant = startDate.getTime() - (long)startDateOffset;
            double differenceDouble = (double)Math.abs(endDateInstant - startDateInstant) / (double)MILLIS_IN_A_DAY;
            difference = differenceDouble < 1.0 ? 1 : (int)differenceDouble;
        }
        return difference;
    }

    public static void resetTime(@Nonnull Date date) {
        date.setTime(date.getTime() / 1000L * 1000L);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
    }

    @Nonnull
    public static Date addDay(@Nonnull Date date, int dayToAdd) {
        Date result = new Date(date.getTime());
        result.setDate(result.getDate() + dayToAdd);
        return result;
    }

    @Nonnull
    public static Date addMonth(@Nonnull Date date, int monthToAdd) {
        Date result = new Date(date.getTime());
        result.setMonth(result.getMonth() + monthToAdd);
        return result;
    }

    @Nonnull
    public static Date addYear(Date date, int yearsToAdd) {
        Date result = new Date(date.getTime());
        result.setYear(result.getYear() + yearsToAdd);
        return result;
    }

    @Nonnull
    public static Date getNextDay(@Nonnull Date date) {
        return Dates.addDay(date, 1);
    }

    @Nonnull
    public static Date getPreviousDay(@Nonnull Date date) {
        return Dates.addDay(date, -1);
    }

    @Nonnull
    public static Date firstOfTheMonth(@Nonnull Date anyDayInMonth) {
        Date first = (Date)anyDayInMonth.clone();
        first.setDate(1);
        return first;
    }

    @Nonnull
    public static Date lastOfTheMonth(@Nonnull Date anyDayInMonth) {
        return Dates.getPreviousDay(Dates.addMonth(Dates.firstOfTheMonth(anyDayInMonth), 1));
    }

    public static boolean isWholeDay(@Nullable Date startDate, @Nullable Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        return new TimePeriod(startDate, endDate).isWholeDay();
    }

    @Nonnull
    public static Date getDateWithTimezone(@Nonnull Date date, @Nonnull TimeZone timeZone) {
        date.setTime(date.getTime() + (long)date.getTimezoneOffset() * MILLIS_PER_MINUTE);
        date.setTime(date.getTime() + timeZone.getTimeZoneOffsetInMillis(date));
        return date;
    }

    @Nonnull
    public static String formatDuration(@Nonnull DateFormatter formatter, @Nonnull Date start, @Nonnull Date end, @Nullable TimeZone timeZone) {
        boolean wholeDay = Dates.isWholeDay(start, end);
        boolean sameDay = Dates.areOnTheSameDay(start, end);
        StringBuilder durationLabel = new StringBuilder();
        if (wholeDay) {
            durationLabel.append(formatter.formatDate(start));
            if (sameDay) {
                return durationLabel.toString();
            }
        } else {
            durationLabel.append(formatter.formatDateTime(start));
        }
        durationLabel.append(LONG_DASH);
        if (wholeDay) {
            return durationLabel.append(formatter.formatDate(end)).toString();
        }
        if (sameDay) {
            durationLabel.append(formatter.formatTime(end));
        } else {
            durationLabel.append(formatter.formatDateTime(end));
        }
        if (timeZone != null) {
            durationLabel.append(" [").append(timeZone.getDisplayString()).append("]");
        }
        return durationLabel.toString();
    }
}

