/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class ChatTokenUtil {
    public static final String NG_PARAM_DELIMITER = " ";
    public static final String NG_CONVERSATION_STATENAME = "conversation";
    public static final String NG_CONVERSATION_PARAMS_PREFIX = "id=";
    public static final String NG_QUERY_PARAMS_PREFIX = "query=";
    public static final String NG_CHAT_QUERY_PARAMS_PREFIX = "chatQuery=";
    public static final String NG_MESSAGE_SEARCH_STATENAME = "searchMessages";

    private ChatTokenUtil() {
    }

    @CheckForNull
    public static ConversationId fromConversationToken(@Nonnull List<HistoryTokenParser.TokenParam> tokenParams) {
        String idParam;
        if (tokenParams.size() < 2) {
            return null;
        }
        HistoryTokenParser.TokenParam statNameToken = tokenParams.get(0);
        String stateName = statNameToken != null ? statNameToken.asString() : "";
        HistoryTokenParser.TokenParam idParamToken = tokenParams.get(1);
        String string = idParam = idParamToken != null ? idParamToken.asString() : "";
        if (!NG_CONVERSATION_STATENAME.equals(stateName) || !idParam.startsWith(NG_CONVERSATION_PARAMS_PREFIX)) {
            return null;
        }
        try {
            UUID id = UUID.fromString(idParam.substring(NG_CONVERSATION_PARAMS_PREFIX.length()));
            return new ConversationId(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

