/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import de.justsoftware.onx.common.shared.util.AbstractTokenUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResultViewType;
import de.justsoftware.onx.searchnew.shared.model.SearchTokenUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtilServer
extends AbstractTokenUtil
implements TokenUtil {
    public static final TokenUtilServer INSTANCE = new TokenUtilServer();
    private static final Logger LOG = LoggerFactory.getLogger(TokenUtilServer.class);

    @Nonnull
    public static String createToken(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, Object ... params) {
        return INSTANCE.createTokenWithDefaultParamsImpl(tokenId, tokenTypes, params, null);
    }

    @Override
    public HistoryTokenParser parse(String token) throws TokenUtil.TokenParseException {
        return new HistoryTokenParser(INSTANCE).parse(token);
    }

    @CheckForNull
    @VisibleForTesting
    public static String encodeParam(@Nullable String s) {
        return INSTANCE.quoteParam(s);
    }

    @Override
    protected String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    @Override
    protected String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    @Override
    protected void logWarn(Object caller, String string) {
        LOG.warn("Expected " + caller + " parameters, but got " + string + " parameters. Ignoring additional parameter...");
    }

    @Nonnull
    public String createSearchToken(SearchParameters input, @Nullable SearchResultViewType targetViewType) {
        return TokenUtilServer.createToken(HistoryToken.SEARCH_TEXT, "SSSLLSSS", SearchTokenUtil.toSearchTokenParamArray(input, targetViewType));
    }

    @Nonnull
    private TokenUtil.TokenIdAndParams parseSearchToken(@Nonnull String searchToken) throws TokenUtil.TokenParseException {
        Object[] defaultParams = SearchTokenUtil.toSearchTokenParamArray(SearchTokenUtil.defaultSearchParameters(), SearchResultViewType.getDefault());
        TokenUtil.TokenIdAndParams tokenIdAndParams = this.parse(searchToken).resolveTypedParams("SSSLLSSS", defaultParams);
        if (tokenIdAndParams.getTokenId() != HistoryToken.SEARCH_TEXT) {
            throw new TokenUtil.TokenParseException("Expected search token, but got a " + tokenIdAndParams.getTokenId().name());
        }
        return tokenIdAndParams;
    }

    @Nonnull
    public SearchParameters parseSearchParametersFromSearchToken(@Nonnull String searchToken, @Nullable EntityId currentEntityId) throws TokenUtil.TokenParseException {
        TokenUtil.TokenIdAndParams tokenIdAndParams = this.parseSearchToken(searchToken);
        return SearchTokenUtil.convertParamsToSearchParameters(tokenIdAndParams.getParams(), currentEntityId);
    }
}

