/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.freiheit.toro.common.shared.server.storage.URLImageFile;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StorageServerUtil.class);

    @CheckForNull
    public static String getFormatNameFromContentType(@Nonnull String contentType) {
        if ("image/jpeg".equals(contentType)) {
            return "jpg";
        }
        if ("image/gif".equals(contentType)) {
            return "gif";
        }
        if ("image/png".equals(contentType)) {
            return "png";
        }
        return null;
    }

    @CheckForNull
    public static URLImageFile createURLImageFile(@Nonnull String urlOfImage) {
        try {
            URL url = new URL(urlOfImage);
            URLConnection conn = url.openConnection();
            String formatType = StorageServerUtil.getFormatNameFromContentType(conn.getContentType());
            if (formatType == null) {
                return null;
            }
            return new URLImageFile(url, conn, formatType);
        }
        catch (MalformedURLException e) {
            LOG.warn("Image url " + urlOfImage + " is not malformed");
            return null;
        }
        catch (IOException e) {
            LOG.warn("Cannot connect to image url " + urlOfImage);
            return null;
        }
    }

    @Nonnull
    public static String createRandomFilenameOfProfileImage(@Nonnull PersonId personId, @Nonnull String fileExtension) {
        return personId.getId() + "-" + SecureRandomUtil.randomHex() + fileExtension;
    }

    public static boolean isOk(@Nullable String s) {
        return "ok".equalsIgnoreCase(StringUtils.trimToEmpty((String)s));
    }
}

