/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.server.util.DOMUtil;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class NodeVisitor<T, E extends Exception> {
    private static final Result<?> SKIP_CHILDREN = new SkipResult(true, false);
    private static final Result<?> VISIT_CHILDREN = new SkipResult(false, false);
    private static final Result<?> SKIP_ELEMENT_END = new SkipResult(false, true);
    private static final Result<?> SKIP_TO_NEXT_SIBLING = new SkipResult(true, true);

    @CheckForNull
    public final T accept(@Nonnull Node node) throws E {
        return (T)NodeVisitor.resultToOptional(this.acceptNodeRecursive(node)).orNull();
    }

    @Nonnull
    private static <T> Optional<T> resultToOptional(@Nonnull Result<T> r) {
        return (Optional)r.accept(new ResultVisitor<T, Optional<T>, RuntimeException>(){

            @Override
            public Optional<T> finalResult(FinalResult<T> result) {
                return Optional.of(result._result);
            }

            @Override
            public Optional<T> skip(SkipResult<T> result) {
                return Optional.absent();
            }
        });
    }

    @Nonnull
    private Result<T> acceptNodeRecursive(final @Nonnull Node node) throws E {
        return (Result)this.acceptSingleNode(node).accept(new ResultVisitor<T, Result<T>, E>(){

            @Override
            public Result<T> finalResult(FinalResult<T> result) {
                return result;
            }

            @Override
            public Result<T> skip(SkipResult<T> result) throws Exception {
                if (!result._skipChildren) {
                    for (Node child : DOMUtil.childNodesIterable(node)) {
                        Result childResult = NodeVisitor.this.acceptNodeRecursive(child);
                        if (!NodeVisitor.resultToOptional(childResult).isPresent()) continue;
                        return childResult;
                    }
                }
                if (!result._skipElementEnd && node.getNodeType() == 1) {
                    return NodeVisitor.this.visitElementEnd((Element)node);
                }
                return result;
            }
        });
    }

    @Nonnull
    private Result<T> acceptSingleNode(@Nonnull Node node) throws E {
        switch (node.getNodeType()) {
            case 1: {
                return this.visitElementStart((Element)node);
            }
            case 4: {
                return this.visitCData((CDATASection)node);
            }
            case 2: {
                return this.visitAttribute((Attr)node);
            }
            case 3: {
                return this.visitTextNode((Text)node);
            }
        }
        return this.visitUnknown(node);
    }

    @Nonnull
    protected final Result<T> result(@Nonnull T result) {
        return new FinalResult<T>(result);
    }

    @Nonnull
    protected final Result<T> skipChildren() {
        return SKIP_CHILDREN;
    }

    @Nonnull
    protected final Result<T> visitChildren() {
        return VISIT_CHILDREN;
    }

    @Nonnull
    protected final Result<T> skipElementEnd() {
        return SKIP_ELEMENT_END;
    }

    @Nonnull
    protected final Result<T> skipToNextSibling() {
        return SKIP_TO_NEXT_SIBLING;
    }

    @Nonnull
    protected abstract Result<T> visitElementStart(@Nonnull Element var1) throws E;

    @Nonnull
    protected abstract Result<T> visitElementEnd(@Nonnull Element var1) throws E;

    @Nonnull
    protected abstract Result<T> visitAttribute(@Nonnull Attr var1) throws E;

    @Nonnull
    protected abstract Result<T> visitTextNode(@Nonnull Text var1) throws E;

    @Nonnull
    protected abstract Result<T> visitCData(@Nonnull CDATASection var1) throws E;

    @Nonnull
    protected abstract Result<T> visitUnknown(@Nonnull Node var1) throws E;

    static interface ResultVisitor<T, R, E extends Exception> {
        @Nonnull
        public R finalResult(@Nonnull FinalResult<T> var1) throws E;

        @Nonnull
        public R skip(@Nonnull SkipResult<T> var1) throws E;
    }

    static final class SkipResult<T>
    implements Result<T> {
        private final boolean _skipChildren;
        private final boolean _skipElementEnd;

        SkipResult(boolean skipChildren, boolean skipElementEnd) {
            this._skipChildren = skipChildren;
            this._skipElementEnd = skipElementEnd;
        }

        @Override
        public <R, E extends Exception> R accept(ResultVisitor<T, R, E> visitor) throws E {
            return visitor.skip(this);
        }
    }

    static final class FinalResult<T>
    implements Result<T> {
        private final T _result;

        FinalResult(@Nonnull T result) {
            this._result = result;
        }

        @Override
        public <R, E extends Exception> R accept(ResultVisitor<T, R, E> visitor) throws E {
            return visitor.finalResult(this);
        }
    }

    public static interface Result<T> {
        @Nonnull
        public <R, E extends Exception> R accept(@Nonnull ResultVisitor<T, R, E> var1) throws E;
    }
}

