/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.shared.server.util.HTMLEscaper;
import de.justsoftware.onx.common.shared.util.UrlDetector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class HtmlUtil {
    private static final Integer MAX_DISPLAYED_URL_CHARS = 20;

    @Nonnull
    public static String addAnchorTags(@Nullable String text, ServerUrlUtil serverUrlUtil, UrlDetector.LinkToNewWindow targetRule) {
        return UrlDetector.addAnchorTagsUnsafe(HTMLEscaper.escape(StringUtils.trimToEmpty((String)text)), MAX_DISPLAYED_URL_CHARS, targetRule, serverUrlUtil.getSystemDomain(), null).replaceAll("\n", "<br />");
    }

    @Nonnull
    public static final String removeHighlightTag(String string) {
        return string.replaceAll("\\[/?hl\\]", "");
    }
}

