/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlParserUtil {
    @Nonnull
    public static Document parseHtml(@Nonnull String html) throws SAXException, IOException {
        return HtmlParserUtil.parseHtml(new StringReader(html));
    }

    @Nonnull
    public static Document parseHtml(@Nonnull Reader htmlIn) throws SAXException, IOException {
        return HtmlParserUtil.parseHtml(new InputSource(htmlIn));
    }

    @Nonnull
    public static Document parseHtml(@Nonnull InputStream in) throws SAXException, IOException {
        try {
            Document document = HtmlParserUtil.parseHtml(new InputSource(in));
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Nonnull
    private static Document parseHtml(@Nonnull InputSource inputSource) throws SAXException, IOException {
        HTMLConfiguration config = new HTMLConfiguration();
        config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        config.setFeature("http://xml.org/sax/features/namespaces", false);
        DOMParser parser = new DOMParser((XMLParserConfiguration)config);
        parser.parse(inputSource);
        return parser.getDocument();
    }

    public static Document generateHtmlDocument(Document head, Document body) {
        DocumentImpl doc = new DocumentImpl();
        Node headCopy = head == null ? null : doc.importNode(head.getFirstChild(), true);
        Node bodyCopy = doc.importNode(body.getFirstChild(), true);
        Element root = doc.createElement("html");
        if (headCopy != null) {
            root.appendChild(headCopy);
        }
        root.appendChild(bodyCopy);
        doc.appendChild(root);
        return doc;
    }
}

