/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server;

import de.justsoftware.onx.common.shared.server.TransactionHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@ParametersAreNonnullByDefault
public class TransactionHelperImpl
implements TransactionHelper {
    private final TransactionTemplate _transactionTemplate;

    @Autowired
    public TransactionHelperImpl(@Qualifier(value="transactionManager") PlatformTransactionManager platformTransactionManager) {
        this._transactionTemplate = new TransactionTemplate(platformTransactionManager);
    }

    @Override
    public <T> T doInTransaction(TransactionCallback<T> transactionCallback) throws TransactionException {
        return (T)this._transactionTemplate.execute(transactionCallback);
    }

    @Override
    public void doInTransactionWithoutResult(TransactionCallbackWithoutResult transactionCallback) throws TransactionException {
        this._transactionTemplate.execute((TransactionCallback)transactionCallback);
    }

    @Override
    public void doAfterTransaction(final TransactionHelper.AfterTransactionCallback transactionCallback) {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            transactionCallback.doAfterTransaction();
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                transactionCallback.doAfterTransaction();
            }
        });
    }
}

