/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@ParametersAreNonnullByDefault
public interface TransactionHelper {
    public <T> T doInTransaction(TransactionCallback<T> var1) throws TransactionException;

    public void doInTransactionWithoutResult(TransactionCallbackWithoutResult var1) throws TransactionException;

    default public void doInTransactionWithoutResult(NoResultTransactionCallback callback) {
        this.doInTransaction(status -> {
            callback.doInTransaction(status);
            return null;
        });
    }

    public void doAfterTransaction(AfterTransactionCallback var1);

    @FunctionalInterface
    public static interface AfterTransactionCallback {
        public void doAfterTransaction();
    }

    @FunctionalInterface
    public static interface NoResultTransactionCallback {
        public void doInTransaction(@Nonnull TransactionStatus var1);
    }
}

