/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.attributes;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import java.math.BigDecimal;
import javax.annotation.Nonnull;

public class NumberInput
implements Input {
    public static final BigDecimal DEFAULT_MIN = BigDecimal.ZERO;
    public static final BigDecimal DEFAULT_MAX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final long serialVersionUID = 1L;
    private BigDecimal _min;
    private BigDecimal _max;
    private int _decimals;

    @Deprecated
    public NumberInput() {
    }

    public NumberInput(@Nonnull BigDecimal min, @Nonnull BigDecimal max, int decimals) {
        this._decimals = decimals;
        this._min = min;
        this._max = max;
    }

    public int getDecimals() {
        return this._decimals;
    }

    @Nonnull
    public BigDecimal getMin() {
        return this._min;
    }

    @Nonnull
    public BigDecimal getMax() {
        return this._max;
    }

    public boolean numberOfDecimalsValid(@Nonnull BigDecimal numberValue) {
        int scale = Math.max(0, numberValue.stripTrailingZeros().scale());
        return scale <= this._decimals;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this._min).add("max", (Object)this._max).add("decimals", this._decimals).toString();
    }

    @Override
    public <T> T accept(Input.InputVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

