/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.shared.model.Identifiables;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EntityDynamicAttributeCalculator {
    private final ImmutableMap<DynamicAttributeId, DynamicAttributeEditModel> _dynamicAttributes;

    public EntityDynamicAttributeCalculator(@Nonnull Iterable<DynamicAttributeEditModel> dynamicAttributes) {
        this._dynamicAttributes = Maps.uniqueIndex(dynamicAttributes, Identifiables.toId());
    }

    @Nonnull
    public ImmutableList<DynamicAttributeEditModel> calculateDynamicAttributes(@Nonnull ImmutableList<DynamicAttributeConfig> configs) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (DynamicAttributeConfig config : configs) {
            Optional<DynamicAttributeEditModel> valuesOfForConfig = this.calculate(config);
            if (!valuesOfForConfig.isPresent()) continue;
            result.add((Object)((DynamicAttributeEditModel)valuesOfForConfig.get()));
        }
        return result.build();
    }

    @CheckForNull
    public DynamicAttributeEditModel calculateDynamicAttributes(@Nonnull DynamicAttributeConfig config) {
        Optional<DynamicAttributeEditModel> valuesOfForConfig = this.calculate(config);
        return (DynamicAttributeEditModel)valuesOfForConfig.orNull();
    }

    @Nonnull
    private Optional<DynamicAttributeEditModel> calculate(final @Nonnull DynamicAttributeConfig config) {
        Optional<DynamicAttributeEditModel> valuesOfType = config.getInput().accept(new Input.InputVisitor<Optional<DynamicAttributeEditModel>>(){

            @Override
            public Optional<DynamicAttributeEditModel> visit(SelectionInput input) {
                return Optional.fromNullable((Object)((DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)config.getId())));
            }

            @Override
            public Optional<DynamicAttributeEditModel> visit(TextInput input) {
                return Optional.fromNullable((Object)((DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)config.getId())));
            }

            @Override
            public Optional<DynamicAttributeEditModel> visit(TextAreaInput input) {
                return Optional.fromNullable((Object)((DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)config.getId())));
            }

            @Override
            public Optional<DynamicAttributeEditModel> visit(PersonSuggestInput suggestInput) {
                return Optional.fromNullable((Object)((DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)config.getId())));
            }

            @Override
            public Optional<DynamicAttributeEditModel> visit(NumberInput numberInput) {
                return Optional.fromNullable((Object)((DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)config.getId())));
            }

            @Override
            public Optional<DynamicAttributeEditModel> visit(final ArithmeticOperationInput input) {
                return Optional.of((Object)input.getOperator().accect(new ArithmeticOperationInput.OperatorVisitor<DynamicAttributeEditModel>(){

                    @Override
                    public DynamicAttributeEditModel visitPlus() {
                        BigDecimal sum = new BigDecimal(0, MathContext.UNLIMITED);
                        for (DynamicAttributeId fieldId : input.getFields()) {
                            DynamicAttributeEditModel sourceAttribute = (DynamicAttributeEditModel)EntityDynamicAttributeCalculator.this._dynamicAttributes.get((Object)fieldId);
                            if (sourceAttribute == null) continue;
                            for (String sourceValue : sourceAttribute.getValues()) {
                                sum = sum.add(Numbers.toBigDecimal(sourceValue));
                            }
                        }
                        return new DynamicAttributeEditModel(config.getId(), (ImmutableList<String>)ImmutableList.of((Object)sum.toPlainString()));
                    }
                }));
            }
        });
        return valuesOfType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dynamicAttributes", this._dynamicAttributes).toString();
    }
}

