/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidatableException
extends Exception {
    private static final long serialVersionUID = -1886762558455959478L;
    private Map<String, Collection<ValidationError>> _errors;

    @Deprecated
    public ValidatableException() {
    }

    public ValidatableException(@Nonnull ImmutableListMultimap<String, ValidationError> errors) {
        this._errors = ImmutableMap.copyOf((Map)errors.asMap());
    }

    public ValidatableException(Map<String, Collection<ValidationError>> errors) {
        this._errors = errors;
    }

    public Map<String, Collection<ValidationError>> getErrors() {
        return this._errors;
    }

    @CheckForNull
    public static String createMessage(@Nullable Map<String, Collection<ValidationError>> errorMap) {
        if (errorMap == null) {
            return null;
        }
        ArrayListMultimap messageIdsByKey = ArrayListMultimap.create();
        for (Map.Entry<String, Collection<ValidationError>> errors : errorMap.entrySet()) {
            for (ValidationError error : errors.getValue()) {
                messageIdsByKey.put((Object)errors.getKey(), (Object)error.getMessage().getKey());
            }
        }
        return Multimaps2.joinMultimap((Multimap<String, String>)messageIdsByKey, Joiner.on((String)", ").skipNulls(), Joiner.on((String)": "));
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = ValidatableException.createMessage(this.getErrors());
        }
        return message;
    }
}

