/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import java.util.Date;

public enum TimeZone {
    AFGHANISTAN("Afghanistan", 4.5, 4.5),
    ALBANIA("Albania", 1.0, 2.0),
    ALGERIA("Algeria", 1.0, 2.0),
    AMERICAN_SAMOA("American Samoa", -11.0, -11.0),
    ANDORRA("Andorra", 1.0, 2.0),
    ANGOLA("Angola", 1.0, 1.0),
    ANGUILLA("Anguilla", -4.0, -4.0),
    ANTARCTICA("Antarctica", -2.0, -2.0),
    ANTIGUA("Antigua", -4.0, -4.0),
    ARGENTINA("Argentina", -3.0, -3.0),
    ARGENTINA_WESTERN_PROV("Argentina western prov", -4.0, -4.0),
    ARMENIA("Armenia", 4.0, 5.0),
    ARUBA("Aruba", -4.0, -4.0),
    ASCENSION("Ascension", 0.0, 0.0),
    AUSTRALIA_NORTHERN_TERRITORY("Australia Northern Territory", 9.5, 9.5),
    AUSTRALIA_LORD_HOWE_ISLAND("Australia Lord Howe Island", 10.5, 11.0),
    AUSTRALIA_NEW_SOUTH_WALES("Australia New South Wales", 10.0, 11.0),
    AUSTRALIA_QUEENSLAND("Australia Queensland", 10.0, 10.0),
    AUSTRALIA_VICTORIA("Australia Victoria", 10.0, 11.0),
    AUSTRALIA_AUSTRALIAN_CAPTIAL_TERRITORY("Australia Australian Captial Territory", 10.0, 11.0),
    AUSTRALIA_SOUTH("Australia South", 9.5, 10.5),
    AUSTRALIA_TASMANIA("Australia Tasmania", 10.0, 11.0),
    AUSTRALIA_WESTERN("Australia Western", 8.0, 8.0),
    AUSTRIA("Austria", 1.0, 2.0),
    AZERBAJIAN("Azerbajian", 3.0, 3.0),
    AZORES("Azores", -1.0, -1.0),
    BAHAMAS("Bahamas", -5.0, -5.0),
    BAHRAIN("Bahrain", 3.0, 3.0),
    BALEARIC_ISLANDS("Balearic Islands", 1.0, 2.0),
    BANGLADESH("Bangladesh", 6.0, 6.0),
    BARBADOS("Barbados", -4.0, -4.0),
    BELARUS("Belarus", 2.0, 3.0),
    BELGIUM("Belgium", 1.0, 2.0),
    BELIZE("Belize", -6.0, -6.0),
    BENIN("Benin", 1.0, 1.0),
    BERMUDA("Bermuda", -4.0, -4.0),
    BHUTAN("Bhutan", 6.0, 6.0),
    BOLIVIA("Bolivia", -4.0, -4.0),
    BONAIRE("Bonaire", -4.0, -4.0),
    BOSNIA_HERCEGOVINA("Bosnia Hercegovina", 1.0, 2.0),
    BOTSWANA("Botswana", 2.0, 2.0),
    BRAZIL_ACRE("Brazil Acre", -4.0, -4.0),
    BRAZIL_ATLANTIC_ISLANDS("Brazil Atlantic Islands", -1.0, -1.0),
    BRAZIL_EAST("Brazil East", -3.0, -3.0),
    BRAZIL_WEST("Brazil West", -4.0, -4.0),
    BRITISH_VIRGIN_ISLANDS("British Virgin Islands", -4.0, -4.0),
    BRUNEI("Brunei", 8.0, 8.0),
    BULGARIA("Bulgaria", 2.0, 3.0),
    BURKINA_FASO("Burkina Faso", 0.0, 0.0),
    BURUNDI("Burundi", 2.0, 2.0),
    CAMBODIA("Cambodia", 7.0, 7.0),
    CAMEROON("Cameroon", 1.0, 1.0),
    CANADA_CENTRAL("Canada Central", -6.0, -6.0),
    CANADA_EASTERN("Canada Eastern", -5.0, -5.0),
    CANADA_MOUNTAIN("Canada Mountain", -7.0, -7.0),
    CANADA_YUKON_PACIFIC("Canada Yukon & Pacific", -8.0, -8.0),
    CANADA_ATLANTIC("Canada Atlantic", -4.0, -4.0),
    CANADA_NEWFOUNDLAND("Canada Newfoundland", -3.5, -3.5),
    CANARY_ISLANDS("Canary Islands", 0.0, 1.0),
    CANTON_ENDERBURY_ISLANDS("Canton Enderbury Islands", -11.0, -11.0),
    CAPE_VERDE("Cape Verde", -1.0, -1.0),
    CAROLINE_ISLAND("Caroline Island", 11.0, 11.0),
    CAYMAN_ISLANDS("Cayman Islands", -5.0, -5.0),
    CENTRAL_AFRICAN_REP("Central African Rep", 1.0, 1.0),
    CHAD("Chad", 1.0, 1.0),
    CHANNEL_ISLANDS("Channel Islands", 0.0, 1.0),
    CHATHAM_ISLAND("Chatham Island", 12.75, 13.75),
    CHILE("Chile", -4.0, -4.0),
    CHINA_PEOPLES_REP("China People's Rep", 8.0, 8.0),
    CHRISTMAS_ISLANDS("Christmas Islands", -10.0, -10.0),
    COLOMBIA("Colombia", -5.0, -5.0),
    CONGO("Congo", 1.0, 1.0),
    COOK_ISLANDS("Cook Islands", -10.0, -10.0),
    COSTA_RICA("Costa Rica", -6.0, -6.0),
    COTE_DIVOIRE("Cote d'Ivoire", 0.0, 0.0),
    CROATIA("Croatia", 1.0, 2.0),
    CUBA("Cuba", -5.0, -5.0),
    CURACAO("Curacao", -4.0, -4.0),
    CYPRUS("Cyprus", 2.0, 3.0),
    CZECH_REPUBLIC("Czech Republic", 1.0, 2.0),
    DAHOMEY("Dahomey", 1.0, 1.0),
    DENMARK("Denmark", 1.0, 2.0),
    DJIBOUTI("Djibouti", 3.0, 3.0),
    DOMINICA("Dominica", -4.0, -4.0),
    DOMINICAN_REPUBLIC("Dominican Republic", -4.0, -4.0),
    EASTER_ISLAND("Easter Island", -6.0, -6.0),
    ECUADOR("Ecuador", -5.0, -5.0),
    EGYPT("Egypt", 2.0, 3.0),
    EL_SALVADOR("El Salvador", -6.0, -6.0),
    ENGLAND("England", 0.0, 1.0),
    EQUITORIAL_GUINEA("Equitorial Guinea", 1.0, 1.0),
    ERITREA("Eritrea", 3.0, 3.0),
    ESTONIA("Estonia", 2.0, 3.0),
    ETHIOPIA("Ethiopia", 3.0, 3.0),
    FALKLAND_ISLANDS("Falkland Islands", -4.0, -4.0),
    FAROE_ISLAND("Faroe Island", 0.0, 1.0),
    FIJI("Fiji", 12.0, 12.0),
    FINLAND("Finland", 2.0, 3.0),
    FRANCE("France", 1.0, 2.0),
    FRENCH_GUIANA("French Guiana", -3.0, -3.0),
    FRENCH_POLYNESIA("French Polynesia", -10.0, -10.0),
    GABON("Gabon", 1.0, 1.0),
    GALAPAGOS_ISLANDS("Galapagos Islands", -5.0, -5.0),
    GAMBIA("Gambia", 0.0, 0.0),
    GAMBIER_ISLAND("Gambier Island", -9.0, -9.0),
    GEORGIA("Georgia", 4.0, 4.0),
    GERMANY("Germany", 1.0, 2.0),
    GHANA("Ghana", 0.0, 0.0),
    GIBRALTAR("Gibraltar", 1.0, 2.0),
    GREECE("Greece", 2.0, 3.0),
    GREENLAND("Greenland", -3.0, -3.0),
    GREENLAND_THULE("Greenland Thule", -4.0, -4.0),
    GREENLAND_SCORESBYSUN("Greenland Scoresbysun", -1.0, -1.0),
    GRENADA("Grenada", -4.0, -4.0),
    GRENADINES("Grenadines", -4.0, -4.0),
    GUADELOUPE("Guadeloupe", -4.0, -4.0),
    GUAM("Guam", 10.0, 10.0),
    GUATEMALA("Guatemala", -6.0, -6.0),
    GUINEA("Guinea", 0.0, 0.0),
    GUINEA_BISSAU("Guinea Bissau", 0.0, 0.0),
    GUYANA("Guyana", -3.0, -3.0),
    HAITI("Haiti", -5.0, -5.0),
    HONDURAS("Honduras", -6.0, -6.0),
    HONG_KONG("Hong kong", 8.0, 8.0),
    HUNGARY("Hungary", 1.0, 2.0),
    ICELAND("Iceland", 0.0, 0.0),
    INDIA("India", 5.5, 5.5),
    INDONESIA_CENTRAL("Indonesia Central", 8.0, 8.0),
    INDONESIA_EAST("Indonesia East", 9.0, 9.0),
    INDONESIA_WEST("Indonesia West", 7.0, 7.0),
    IRAN("Iran", 3.5, 3.5),
    IRAQ("Iraq", 3.0, 4.0),
    IRELAND_REPUBLIC_OF("Ireland Republic of", 0.0, 1.0),
    ISRAEL("Israel", 2.0, 3.0),
    ITALY("Italy", 1.0, 2.0),
    JAMAICA("Jamaica", -5.0, -5.0),
    JAPAN("Japan", 9.0, 9.0),
    JOHNSTON_ISLAND("Johnston Island", -10.0, -10.0),
    JORDAN("Jordan", 2.0, 3.0),
    KAZAKHSTAN("Kazakhstan", 6.0, 7.0),
    KENYA("Kenya", 3.0, 3.0),
    KIRIBATI("Kiribati", 12.0, 12.0),
    KOREA_DEM_REPUBLIC_OF("Korea Dem Republic of", 9.0, 9.0),
    KOREA_REPUBLIC_OF("Korea Republic of", 9.0, 9.0),
    KUSAIE("Kusaie", 12.0, 12.0),
    KUWAIT("Kuwait", 3.0, 3.0),
    KWAJALEIN("Kwajalein", -12.0, -12.0),
    KYRGYZSTAN("Kyrgyzstan", 5.0, 6.0),
    LAOS("Laos", 7.0, 7.0),
    LATVIA("Latvia", 2.0, 3.0),
    LEBANON("Lebanon", 2.0, 3.0),
    LEEWARD_ISLANDS("Leeward Islands", -4.0, -4.0),
    LESOTHO("Lesotho", 2.0, 2.0),
    LIBERIA("Liberia", 0.0, 0.0),
    LIBYA("Libya", 2.0, 2.0),
    LITHUANIA("Lithuania", 2.0, 3.0),
    LUXEMBOURG("Luxembourg", 1.0, 2.0),
    MACEDONIA("Macedonia", 1.0, 2.0),
    MADAGASCAR("Madagascar", 3.0, 3.0),
    MADEIRA("Madeira", 0.0, 1.0),
    MALAWI("Malawi", 2.0, 2.0),
    MALAYSIA("Malaysia", 8.0, 8.0),
    MALDIVES("Maldives", 5.0, 5.0),
    MALI("Mali", 0.0, 0.0),
    MALLORCA_ISLANDS("Mallorca Islands", 1.0, 2.0),
    MALTA("Malta", 1.0, 2.0),
    MARIANA_ISLAND("Mariana Island", 10.0, 10.0),
    MARQUESAS_ISLANDS("Marquesas Islands", -9.5, -9.5),
    MARSHALL_ISLANDS("Marshall Islands", 12.0, 12.0),
    MARTINIQUE("Martinique", -4.0, -4.0),
    MAURITANIA("Mauritania", 0.0, 0.0),
    MAURITIUS("Mauritius", 4.0, 4.0),
    MAYOTTE("Mayotte", 3.0, 3.0),
    MELILLA("Melilla", 1.0, 2.0),
    MEXICO("Mexico", -6.0, -6.0),
    MEXICO_BAJA_CALIF_NORTE("Mexico Baja Calif Norte", -8.0, -8.0),
    MEXICO_NAYARIT("Mexico Nayarit", -7.0, -7.0),
    MEXICO_SINALOA("Mexico Sinaloa", -7.0, -7.0),
    MEXICO_SONORA("Mexico Sonora", -7.0, -7.0),
    MIDWAY_ISLAND("Midway Island", -11.0, -11.0),
    MOLDOVA("Moldova", 2.0, 3.0),
    MOLDOVIAN_REP_PRIDNESTROVYE("Moldovian Rep Pridnestrovye", 2.0, 3.0),
    MONACO("Monaco", 1.0, 2.0),
    MONGOLIA("Mongolia", 8.0, 8.0),
    MOROCCO("Morocco", 0.0, 0.0),
    MOZAMBIQUE("Mozambique", 2.0, 2.0),
    MYANMAR("Myanmar", 6.5, 6.5),
    NAMIBIA("Namibia", 1.0, 2.0),
    NAURU_REPUBLIC_OF("Nauru Republic of", 12.0, 12.0),
    NEPAL("Nepal", 5.75, 5.75),
    NETHERLANDS("Netherlands", 1.0, 2.0),
    NETHERLANDS_ANTILLES("Netherlands Antilles", -4.0, -4.0),
    NEVIS_MONTSERRAT("Nevis Montserrat", -4.0, -4.0),
    NEW_CALEDONIA("New Caledonia", 11.0, 11.0),
    NEW_HEBRIDES("New Hebrides", 11.0, 11.0),
    NEW_ZEALAND("New Zealand", 12.0, 13.0),
    NICARAGUA("Nicaragua", -6.0, -6.0),
    NIGER("Niger", 1.0, 1.0),
    NIGERIA("Nigeria", 1.0, 1.0),
    NIUE_ISLAND("Niue Island", -11.0, -11.0),
    NORFOLK_ISLAND("Norfolk Island", 11.5, 11.5),
    NORTHERN_IRELAND("Northern Ireland", 0.0, 1.0),
    NORTHERN_MARIANA_ISLANDS("Northern Mariana Islands", 10.0, 10.0),
    NORWAY("Norway", 1.0, 2.0),
    OMAN("Oman", 4.0, 4.0),
    PAKISTAN("Pakistan", 5.0, 5.0),
    PALAU("Palau", 9.0, 9.0),
    PANAMA("Panama", -5.0, -5.0),
    PAPUA_NEW_GUINEA("Papua New Guinea", 10.0, 10.0),
    PARAGUAY("Paraguay", -4.0, -4.0),
    PERU("Peru", -5.0, -5.0),
    PHILIPPINES("Philippines", 8.0, 8.0),
    PINGELAP("Pingelap", 12.0, 12.0),
    POLAND("Poland", 1.0, 2.0),
    PONAPE_ISLAND("Ponape Island", 11.0, 11.0),
    PORTUGAL("Portugal", 1.0, 2.0),
    PRINCIPE_ISLAND("Principe Island", 0.0, 0.0),
    PUERTO_RICO("Puerto Rico", -4.0, -4.0),
    QATAR("Qatar", 3.0, 3.0),
    REUNION("Reunion", 4.0, 4.0),
    ROMANIA("Romania", 2.0, 3.0),
    RUSSIAN_FEDERATION_ZONE_ONE("Russian Federation zone one", 2.0, 3.0),
    RUSSIAN_FEDERATION_ZONE_TWO("Russian Federation zone two", 4.0, 5.0),
    RUSSIAN_FEDERATION_ZONE_THREE("Russian Federation zone three", 4.0, 5.0),
    RUSSIAN_FEDERATION_ZONE_FOUR("Russian Federation zone four", 5.0, 6.0),
    RUSSIAN_FEDERATION_ZONE_FIVE("Russian Federation zone five", 6.0, 7.0),
    RUSSIAN_FEDERATION_ZONE_SIX("Russian Federation zone six", 7.0, 8.0),
    RUSSIAN_FEDERATION_ZONE_SEVEN("Russian Federation zone seven", 8.0, 9.0),
    RUSSIAN_FEDERATION_ZONE_EIGHT("Russian Federation zone eight", 9.0, 10.0),
    RUSSIAN_FEDERATION_ZONE_NINE("Russian Federation zone nine", 10.0, 11.0),
    RUSSIAN_FEDERATION_ZONE_TEN("Russian Federation zone ten", 11.0, 12.0),
    RUSSIAN_FEDERATION_ZONE_ELEVEN("Russian Federation zone eleven", 12.0, 13.0),
    RWANDA("Rwanda", 2.0, 2.0),
    SABA("Saba", -4.0, -4.0),
    SAMOA("Samoa", -11.0, -11.0),
    SAN_MARINO("San Marino", 1.0, 2.0),
    SAO_TOME_E_PRINCIPE("Sao Tome e Principe", 0.0, 0.0),
    SAUDI_ARABIA("Saudi Arabia", 3.0, 3.0),
    SCOTLAND("Scotland", 0.0, 1.0),
    SENEGAL("Senegal", 0.0, 0.0),
    SEYCHELLES("Seychelles", 4.0, 4.0),
    SIERRA_LEONE("Sierra Leone", 0.0, 0.0),
    SINGAPORE("Singapore", 8.0, 8.0),
    SLOVAKIA("Slovakia", 1.0, 2.0),
    SLOVENIA("Slovenia", 1.0, 2.0),
    SOCIETY_ISLAND("Society Island", -10.0, -10.0),
    SOLOMON_ISLANDS("Solomon Islands", 11.0, 11.0),
    SOMALIA("Somalia", 3.0, 3.0),
    SOUTH_AFRICA("South Africa", 2.0, 2.0),
    SPAIN("Spain", 1.0, 2.0),
    SRI_LANKA("Sri Lanka", 5.5, 5.5),
    ST_CHRISTOPHER("St Christopher", -4.0, -4.0),
    ST_CROIX("St Croix", -4.0, -4.0),
    ST_HELENA("St Helena", 0.0, 0.0),
    ST_JOHN("St John", -4.0, -4.0),
    ST_KITTS_NEVIS("St Kitts Nevis", -4.0, -4.0),
    ST_LUCIA("St Lucia", -4.0, -4.0),
    ST_MAARTEN("St Maarten", -4.0, -4.0),
    ST_PIERRE_MIQUELON("St Pierre & Miquelon", -3.0, -3.0),
    ST_THOMAS("St Thomas", -4.0, -4.0),
    ST_VINCENT("St Vincent", -4.0, -4.0),
    SUDAN("Sudan", 2.0, 2.0),
    SURINAME("Suriname", -3.0, -3.0),
    SWAZILAND("Swaziland", 2.0, 2.0),
    SWEDEN("Sweden", 1.0, 2.0),
    SWITZERLAND("Switzerland", 1.0, 2.0),
    SYRIA("Syria", 2.0, 3.0),
    TAHITI("Tahiti", -10.0, -10.0),
    TAIWAN("Taiwan", 8.0, 8.0),
    TAJIKISTAN("Tajikistan", 6.0, 6.0),
    TANZANIA("Tanzania", 3.0, 3.0),
    THAILAND("Thailand", 7.0, 7.0),
    TOGO("Togo", 0.0, 0.0),
    TONGA("Tonga", 13.0, 13.0),
    TRINIDAD_AND_TOBAGO("Trinidad and Tobago", -4.0, -4.0),
    TUAMOTU_ISLAND("Tuamotu Island", -10.0, -10.0),
    TUBUAI_ISLAND("Tubuai Island", -10.0, -10.0),
    TUNISIA("Tunisia", 1.0, 1.0),
    TURKEY("Turkey", 2.0, 3.0),
    TURKMENISTAN("Turkmenistan", 5.0, 5.0),
    TURKS_AND_CAICOS_ISLANDS("Turks and Caicos Islands", -5.0, -5.0),
    TUVALU("Tuvalu", 12.0, 12.0),
    UGANDA("Uganda", 3.0, 3.0),
    UKRAINE("Ukraine", 2.0, 3.0),
    UNITED_ARAB_EMIRATES("United Arab Emirates", 4.0, 4.0),
    UNITED_KINGDOM("United Kingdom", 0.0, 1.0),
    USA_EASTERN("USA Eastern", -5.0, -4.0),
    USA_INDIANA_EAST("USA Indiana East", -5.0, -5.0),
    USA_CENTRAL("USA Central", -6.0, -5.0),
    USA_ARIZONA("USA Arizona", -7.0, -7.0),
    USA_MOUNTAIN("USA Mountain", -7.0, -6.0),
    USA_PACIFIC("USA Pacific", -8.0, -8.0),
    USA_ALASKA("USA Alaska", -9.0, -9.0),
    USA_ALEUTIAN("USA Aleutian", -10.0, -10.0),
    USA_HAWAII("USA Hawaii", -10.0, -10.0),
    URUGUAY("Uruguay", -3.0, -3.0),
    UZBEKISTAN("Uzbekistan", 5.0, 5.0),
    VANUATU("Vanuatu", 11.0, 12.0),
    VATICAN_CITY("Vatican City", 1.0, 2.0),
    VENEZUELA("Venezuela", -4.0, -4.0),
    VIETNAM("Vietnam", 7.0, 7.0),
    VIRGIN_ISLANDS("Virgin Islands", -4.0, -4.0),
    WAKE_ISLAND("Wake Island", 12.0, 12.0),
    WALES("Wales", 0.0, 1.0),
    WALLIS_AND_FUTUNA_ISLANDS("Wallis and Futuna Islands", 12.0, 12.0),
    WINDWARD_ISLANDS("Windward Islands", -4.0, -4.0),
    YEMEN("Yemen", 3.0, 3.0),
    YUGOSLAVIA("Yugoslavia", 1.0, 2.0),
    ZAIRE_KASAI("Zaire Kasai", 2.0, 2.0),
    ZAIRE_KINSHASA_MBANDAKA("Zaire Kinshasa Mbandaka", 1.0, 1.0),
    ZAIRE_HAUT_ZAIRE("Zaire Haut Zaire", 2.0, 2.0),
    ZAIRE_KIVU("Zaire Kivu", 2.0, 2.0),
    ZAIRE_SHABA("Zaire Shaba", 2.0, 2.0),
    ZAMBIA("Zambia", 2.0, 2.0),
    ZIMBABWE("Zimbabwe", 2.0, 2.0);

    private static final int HOUR_IN_MS = 3600000;
    private final String _country;
    private final double _gmtOffsetWinter;
    private final double _gmtOffsetSommer;

    private TimeZone(String country, double gmtOffsetWinter, double gmtOffsetSommer) {
        this._country = country;
        this._gmtOffsetSommer = gmtOffsetSommer;
        this._gmtOffsetWinter = gmtOffsetWinter;
    }

    public long getTimeZoneOffsetInMillis(Date date) {
        double offset = this.getOffset(date);
        return Math.round(offset * 3600000.0);
    }

    public String getCountry() {
        return this._country;
    }

    public double getGmtOffsetSommer() {
        return this._gmtOffsetSommer;
    }

    public double getGmtOffsetWinter() {
        return this._gmtOffsetWinter;
    }

    public String getGMTString(Date date) {
        return TimeZone.getGMTString(this, date);
    }

    public String getDisplayString() {
        String result = this._country + " (GMT";
        if (this._gmtOffsetWinter != 0.0) {
            if (this._gmtOffsetWinter > 0.0) {
                result = result + "+";
            }
            result = result + String.valueOf(this._gmtOffsetWinter);
        }
        result = result + ")";
        return result;
    }

    public static Date getSommerTimeStartDate(int year) {
        boolean sundayCode = false;
        for (int i = 31; i >= 20; --i) {
            Date c = new Date(year - 1900, 2, i, 1, 59, 59);
            if (c.getDay() != 0) continue;
            return c;
        }
        return null;
    }

    public static Date getWinterTimeStartDate(int year) {
        boolean sundayCode = false;
        for (int i = 31; i >= 20; --i) {
            Date c = new Date(year - 1900, 9, i, 1, 59, 59);
            if (c.getDay() != 0) continue;
            return c;
        }
        return null;
    }

    public static boolean isSommerTime(Date date) {
        int year = date.getYear() + 1900;
        Date summerTimeStartDate = TimeZone.getSommerTimeStartDate(year);
        Date winterTimeStartDate = TimeZone.getWinterTimeStartDate(year);
        return summerTimeStartDate.before(date) && winterTimeStartDate.after(date);
    }

    public static boolean isWinterTime(Date date) {
        return !TimeZone.isSommerTime(date);
    }

    public static String getGMTString(TimeZone timeZone, Date date) {
        double offset = timeZone.getOffset(date);
        return "GMT" + TimeZone.getTimeStringFromDouble(offset);
    }

    public double getOffset(Date date) {
        return TimeZone.isSommerTime(date) ? this.getGmtOffsetSommer() : this.getGmtOffsetWinter();
    }

    public Date getUTCDate(Date d) {
        return new Date(d.getTime() - this.getTimeZoneOffsetInMillis(d));
    }

    private static String getTimeStringFromDouble(double val) {
        Object result = "";
        double offset = val;
        if (offset >= 0.0) {
            result = "+";
        } else {
            offset = -1.0 * offset;
            result = "-";
        }
        result = (String)result + (int)offset + ":";
        int minutesOffset = (int)((offset - (double)((int)offset)) * 100.0);
        int minutes = (int)((double)(60 * minutesOffset) / 100.0);
        result = (String)result + (minutes < 10 ? "0" : "") + minutes;
        return result;
    }
}

