/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.ItemType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProfileId
extends GlobalId {
    public static final Function<ProfileId, PersonId> TO_PERSON_ID = new Function<ProfileId, PersonId>(){

        public PersonId apply(ProfileId input) {
            if (input == null) {
                return null;
            }
            return input.asPersonId();
        }
    };
    private static final long serialVersionUID = -6822976788908499274L;

    @Deprecated
    public ProfileId() {
    }

    public ProfileId(long id) {
        super(id);
    }

    @Override
    public ItemType getType() {
        return ItemType.PROFILE;
    }

    @Nonnull
    public PersonId asPersonId() {
        return new PersonId(this.getId());
    }

    @Override
    public <T> T accept(ItemIdVisitor<T> v) {
        return v.visit(this);
    }

    @CheckForNull
    public static ProfileId valueOf(@Nullable PersonId personId) {
        return personId != null ? personId.asProfileId() : null;
    }

    @Nonnull
    public static ProfileId valueOf(@Nonnull Long id) {
        return new ProfileId(id);
    }

    @CheckForNull
    public static ProfileId parse(@Nullable String string) {
        if (string == null) {
            return null;
        }
        GlobalId id = GlobalId.parse(string);
        if (id == null) {
            return null;
        }
        if (id instanceof ProfileId) {
            return (ProfileId)id;
        }
        throw new IdParseException("Failed to parse '" + string + "' to ProfiledId");
    }

    @Nonnull
    public static ProfileId parseNonnull(@Nonnull String string) {
        GlobalId id = GlobalId.parse(string);
        if (id instanceof ProfileId) {
            return (ProfileId)id;
        }
        throw new IdParseException("Failed to parse '" + string + "' to ProfiledId");
    }
}

