/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Link
implements Serializable {
    private static final long serialVersionUID = 6403960779691254600L;
    private String _text;
    private String _href;
    private String _target = null;

    public Link() {
    }

    public Link(@Nullable String text, @Nullable String href) {
        this._text = text;
        this._href = href;
    }

    public Link(String text, String href, String target) {
        this._text = text;
        this._href = href;
        this._target = target;
    }

    @CheckForNull
    public String getText() {
        return this._text;
    }

    @CheckForNull
    public String getHref() {
        return this._href;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void setHref(String href) {
        this._href = href;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public String getTextOrHref() {
        return StringUtil.isBlank(this._text) ? this._href : this._text;
    }

    @Nonnull
    public String getTextOrHref(@Nonnull String fallback) {
        String textOrHref = this.getTextOrHref();
        return StringUtil.isBlank(textOrHref) ? fallback : textOrHref;
    }

    public boolean hasLink() {
        return !StringUtil.isBlank(this._href);
    }

    @Nonnull
    public String getHrefOrEmpty() {
        return Strings.nullToEmpty((String)this._href);
    }

    @Nonnull
    protected MoreObjects.ToStringHelper superToStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("text", (Object)this._text).add("href", (Object)this._href).add("target", (Object)this._target);
    }

    public String toString() {
        return this.superToStringHelper().toString();
    }
}

