/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface IEntityVersion
extends Identifiable<EntityVersionId> {
    public static final Function<IEntityVersion, EntityVersionId> GET_ID = new Function<IEntityVersion, EntityVersionId>(){

        public EntityVersionId apply(IEntityVersion input) {
            return input != null ? input.getId() : null;
        }
    };
    public static final Function<IEntityVersion, PersonId> TO_AUTHOR_ID = new Function<IEntityVersion, PersonId>(){

        public PersonId apply(IEntityVersion input) {
            return input != null ? input.getAuthorId() : null;
        }
    };
    public static final Function<IEntityVersion, EntityId> GET_ENTITY_ID = new Function<IEntityVersion, EntityId>(){

        public EntityId apply(IEntityVersion input) {
            return input != null ? input.getEntityId() : null;
        }
    };

    @Override
    @Nonnull
    public EntityVersionId getId();

    @Nonnull
    public EntityId getEntityId();

    @Nonnull
    public PersonId getAuthorId();

    public int getMajorVersion();

    public int getMinorVersion();

    public int getDraftVersion();

    @CheckForNull
    public String getChangeMessage();

    @CheckForNull
    public String getCommentForReviewers();

    @CheckForNull
    public String getDeclineMessage();

    @Nonnull
    public EntityStatus getStatus();

    @Nonnull
    public EntityVersionType getVersionType();

    @CheckForNull
    public EntityVersionType getTargetType();

    @CheckForNull
    public DateWithoutTimezone getReleaseDate();

    @CheckForNull
    public DateWithoutTimezone getExpirationDate();

    @CheckForNull
    public DateWithoutTimezone getModificationDate();

    @Nonnull
    public String getVersionString();

    @CheckForNull
    public DateWithoutTimezone getCreationDate();
}

