/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import javax.annotation.Nonnull;

public class EntityVersionReviewerConfig {
    private final Range _reviewerRange;
    private final ImmutableList<ImmutableSet<Role>> _reviewerRoles;

    public EntityVersionReviewerConfig(@Nonnull Range reviewerRange) {
        this(reviewerRange, (ImmutableList<ImmutableSet<Role>>)ImmutableList.of());
    }

    public EntityVersionReviewerConfig(@Nonnull Range reviewerRange, @Nonnull ImmutableList<ImmutableSet<Role>> reviewers) {
        this._reviewerRange = reviewerRange;
        this._reviewerRoles = reviewers;
    }

    @Nonnull
    public static EntityVersionReviewerConfig getDefaultInstance() {
        return new EntityVersionReviewerConfig(Range.UNRESTRICTED_NON_ZERO);
    }

    @Nonnull
    public Range getReviewerRange() {
        return this._reviewerRange;
    }

    @Nonnull
    public ImmutableList<ImmutableSet<Role>> getReviewers() {
        return this._reviewerRoles;
    }

    public boolean hasPredefinedReviewerRolesForStage(int reviewStage) {
        return reviewStage < this.getReviewers().size();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("reviewerRange", (Object)this._reviewerRange).add("reviewerRoles", (Object)this._reviewerRoles.toString()).toString();
    }
}

