/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.DefaultComponentTypeVisitor;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentModel
implements Serializable {
    public static final Function<ComponentModel, ComponentPositionConfig> POSITION_CONFIG = new Function<ComponentModel, ComponentPositionConfig>(){

        public ComponentPositionConfig apply(ComponentModel input) {
            return input != null ? input._positionConfig : null;
        }
    };
    public static final Function<ComponentModel, ComponentPosition> POSITION = Functions.compose(ComponentPositionConfig.POSITION_FUNCTION, POSITION_CONFIG);
    public static final Predicate<ComponentModel> IS_VISIBLE_PREDICATE = new Predicate<ComponentModel>(){

        public boolean apply(final ComponentModel input) {
            if (input == null || !input.getPositionConfig().isVisible()) {
                return false;
            }
            return Boolean.TRUE.equals(input.getType().accept(new DefaultComponentTypeVisitor<Boolean>(){

                @Override
                public Boolean visitRawEditor1() {
                    return this.visitRawEditor();
                }

                @Nonnull
                private Boolean visitRawEditor() {
                    RawEditorVersion editorVersion = (RawEditorVersion)input.getModuleData();
                    if (editorVersion == null) {
                        return Boolean.FALSE;
                    }
                    if (editorVersion.getMay().contains((Object)StaticAction.RAWEDITOR_WRITE)) {
                        return Boolean.TRUE;
                    }
                    return !StringUtil.isBlank(editorVersion.getText());
                }

                @Override
                public Boolean visitRawEditor2() {
                    return this.visitRawEditor();
                }

                @Override
                public Boolean visitRawEditor3() {
                    return this.visitRawEditor();
                }

                @Override
                public Boolean visitRawEditor4() {
                    return this.visitRawEditor();
                }

                @Override
                public Boolean visitDocument() {
                    return Boolean.FALSE;
                }

                @Override
                protected Boolean visitDefault() {
                    return Boolean.TRUE;
                }
            }));
        }
    };
    public static final Function<ComponentModel, ComponentType> TO_TYPE = new NullPermeableFunction<ComponentModel, ComponentType>(){

        @Override
        protected ComponentType applySafe(ComponentModel input) {
            return input.getType();
        }
    };
    private static final long serialVersionUID = 2L;
    private ComponentPositionConfig _positionConfig;
    private GlobalId _parentId;
    @CheckForNull
    private ModuleData _moduleData;

    @Deprecated
    public ComponentModel() {
    }

    public ComponentModel(@Nonnull GlobalId parentId, @Nonnull ComponentPositionConfig positionConfig, @Nullable ModuleData moduleData) {
        this._moduleData = moduleData;
        this._parentId = parentId;
        this._positionConfig = positionConfig;
    }

    @Nonnull
    public GlobalId getParentId() {
        return this._parentId;
    }

    @CheckForNull
    public ModuleData getModuleData() {
        return this._moduleData;
    }

    @Nonnull
    public ComponentType getType() {
        return this._positionConfig.getType();
    }

    @Nonnull
    public ComponentPositionConfig getPositionConfig() {
        return this._positionConfig;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionConfig", (Object)this._positionConfig).add("parentId", (Object)this._parentId).add("moduleData", (Object)this._moduleData).toString();
    }
}

