/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.i18n;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;

public final class EntityTranslationUtil {
    private static final ImmutableMap<EntityType, String> ENTITY_KEY_MAP = new ImmutableMap.Builder().put((Object)EntityType.APPOINTMENT, (Object)"Appointment").put((Object)EntityType.ARTICLE, (Object)"Article").put((Object)EntityType.GROUP, (Object)"Group").put((Object)EntityType.NETWORK, (Object)"Network").put((Object)EntityType.PARTNERSITE, (Object)"Partnersite").put((Object)EntityType.PUBLICATION, (Object)"Publication").put((Object)EntityType.TOPIC, (Object)"Topic").put((Object)EntityType.WIKI, (Object)"Wiki").build();

    @Nonnull
    public static String getEntityTypeKeyPart(@Nonnull EntityType type) {
        String mapValue = (String)ENTITY_KEY_MAP.get((Object)type);
        if (mapValue != null) {
            return mapValue;
        }
        return type.getName();
    }

    @Nonnull
    public static String getEntityTypeStatusKeyPart(@Nonnull EntityType type, @Nonnull EntityStatus status) {
        return type.getName() + "/" + status.getName();
    }

    @Nonnull
    public static String getEntityTypeAttributesKeyPart(@Nonnull EntityType type, @Nonnull DynamicAttributeId attributeId) {
        return EntityTranslationUtil.getEntityTypeKeyPart(type) + "/" + attributeId.getId();
    }

    @Nonnull
    public static String getDynamicOptionTranslationKey(@Nonnull EntityType entityType, @Nonnull DynamicAttributeId attributeId, @Nonnull String value) {
        String prefix = "Entity/Attributes/" + EntityTranslationUtil.getEntityTypeAttributesKeyPart(entityType, attributeId);
        return prefix + "/values/" + value;
    }
}

