/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisStatementBuilderFactory
implements StatementBuilderFactory {
    private final String _jdbcDBType;
    private final SqlMapClient _sqlMapClient;

    @Autowired
    public IbatisStatementBuilderFactory(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, @Value(value="${JDBC.DBType}") String jdbcDBType) {
        this._sqlMapClient = sqlMapClient;
        this._jdbcDBType = jdbcDBType;
    }

    @Override
    public IbatisStatementBuilder ibatistStatementBuilder(String namespace) {
        return new IbatisStatementBuilder(this._sqlMapClient, namespace, this._jdbcDBType);
    }
}

