/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.util.Numbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class IbatisResultBuilder {
    protected abstract void executeWithRowHandler(IbatisDAOUtil.TypedRowHandler<?> var1);

    @Nonnull
    public <R, C, V> ImmutableTable<R, C, V> asTable(String rowColumn, String colColumn, @Nullable String valColumn) {
        return this.asTable((Function)IbatisDAOUtil.singlePropertyFunction(rowColumn), (Function)IbatisDAOUtil.singlePropertyFunction(colColumn), (Function)IbatisDAOUtil.singlePropertyFunction(valColumn));
    }

    @Nonnull
    public <R, C, V, O> ImmutableTable<R, C, V> asTable(Function<O, R> rowFunction, Function<O, C> colFunction, Function<O, V> valFunction) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        this.executeWithRowHandler(valueObject -> {
            if (valueObject != null) {
                Object row = rowFunction.apply(valueObject);
                Object col = colFunction.apply(valueObject);
                Object val = valFunction.apply(valueObject);
                if (row != null && col != null && val != null) {
                    builder.put(row, col, val);
                }
            }
        });
        return builder.build();
    }

    @Nonnull
    public <K, V> ImmutableMap<K, V> asMap(String keyProperty, @Nullable String valueProperty) {
        return this.asMap((Function)IbatisDAOUtil.singlePropertyFunction(keyProperty), (Function)IbatisDAOUtil.singlePropertyFunction(valueProperty));
    }

    @Nonnull
    public <K, V> ImmutableMap<K, V> asMap(Function<? super V, K> keyFunction) {
        return this.asMap(keyFunction, Function.identity());
    }

    @Nonnull
    public <K, V, O> ImmutableMap<K, V> asMap(Function<? super O, K> keyFunction, Function<? super O, V> valueFunction) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.executeWithBiConsumer(keyFunction, valueFunction, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    @Nonnull
    public <K> ImmutableMultiset<K> asMultiset(String keyProperty, @Nullable String countProperty) {
        return this.asMultiset((Function)IbatisDAOUtil.singlePropertyFunction(keyProperty), (Function)IbatisDAOUtil.singlePropertyFunction(countProperty));
    }

    @Nonnull
    public <K, O> ImmutableMultiset<K> asMultiset(Function<? super O, K> keyFunction, Function<? super O, Integer> countFunction) {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        this.executeWithBiConsumer(keyFunction, countFunction, (arg_0, arg_1) -> ((ImmutableMultiset.Builder)builder).setCount(arg_0, arg_1));
        return builder.build();
    }

    @Nonnull
    public <K, V> ImmutableListMultimap<K, V> asListMultimap(String keyColumn, @Nullable String valueColumn) {
        return this.asListMultimap((Function)IbatisDAOUtil.singlePropertyFunction(keyColumn), (Function)IbatisDAOUtil.singlePropertyFunction(valueColumn));
    }

    @Nonnull
    public <K, V, O> ImmutableListMultimap<K, V> asListMultimap(Function<O, K> keyFunction, Function<O, V> valueFunction) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        this.executeWithBiConsumer(keyFunction, valueFunction, (arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    @Nonnull
    public <K, V> ImmutableSetMultimap<K, V> asSetMultimap(String keyColumn, @Nullable String valueColumn) {
        return this.asSetMultimap((Function)IbatisDAOUtil.singlePropertyFunction(keyColumn), (Function)IbatisDAOUtil.singlePropertyFunction(valueColumn));
    }

    @Nonnull
    public <K, V, O> ImmutableSetMultimap<K, V> asSetMultimap(Function<O, K> keyFunction, Function<O, V> valueFunction) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        this.executeWithBiConsumer(keyFunction, valueFunction, (arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    @Nonnull
    public <V> ImmutableSet<V> asSet() {
        return this.asSet(Function.identity());
    }

    @Nonnull
    public <V> ImmutableSet<V> asSet(String valueColumn) {
        return this.asSet((Function)IbatisDAOUtil.singlePropertyFunction(valueColumn));
    }

    @Nonnull
    public <O, V> ImmutableSet<V> asSet(Function<? super O, V> valueFunction) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.executeWithConsumer(valueFunction, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    public <V> ImmutableList<V> asList() {
        return this.asList(Function.identity());
    }

    @Nonnull
    public <V> ImmutableList<V> asList(String valueColumn) {
        return this.asList((Function)IbatisDAOUtil.singlePropertyFunction(valueColumn));
    }

    @Nonnull
    public <O, V> ImmutableList<V> asList(Function<? super O, V> valueFunction) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.executeWithConsumer(valueFunction, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @CheckForNull
    public <V> V asObject() {
        AtomicReference result = new AtomicReference();
        this.executeWithRowHandler(value -> {
            if (value == null) {
                return;
            }
            Object existing = result.getAndSet(value);
            if (existing != null) {
                throw new DAOException(String.format("expected only a single result but got multiples, first was %s, second was %s", existing, value));
            }
        });
        return result.get();
    }

    public int asCount() {
        return Numbers.intValue((Number)this.asObject());
    }

    @Nonnull
    public <V> Optional<V> asOptional() {
        return Optional.ofNullable(this.asObject());
    }

    public <T> int executeWithConsumer(Consumer<T> consumer) {
        AtomicInteger counter = new AtomicInteger(0);
        this.executeWithRowHandler(value -> {
            counter.incrementAndGet();
            consumer.accept(value);
        });
        return counter.get();
    }

    public <O, T> int executeWithConsumer(Function<? super O, T> valueFunction, Consumer<T> consumer) {
        return this.executeWithConsumer(o -> {
            Object t;
            if (o != null && (t = valueFunction.apply((Object)o)) != null) {
                consumer.accept(t);
            }
        });
    }

    public <T, U> int executeWithBiConsumer(String leftColumn, String rightColumn, BiConsumer<T, U> consumer) {
        return this.executeWithBiConsumer((Function)IbatisDAOUtil.singlePropertyFunction(leftColumn), (Function)IbatisDAOUtil.singlePropertyFunction(rightColumn), (BiConsumer)consumer);
    }

    public <O, K, V> int executeWithBiConsumer(Function<? super O, K> keyFunction, Function<? super O, V> valueFunction, BiConsumer<K, V> consumer) {
        return this.executeWithConsumer(o -> {
            if (o != null) {
                Object key = keyFunction.apply((Object)o);
                Object value = valueFunction.apply((Object)o);
                if (key != null && value != null) {
                    consumer.accept(key, value);
                }
            }
        });
    }

    private <T> int consumeChunked(int chunkSize, Consumer<? super ArrayList<T>> consumer) {
        ArrayList queue = new ArrayList(chunkSize);
        int result = this.executeWithConsumer(t -> {
            queue.add(t);
            if (queue.size() >= chunkSize) {
                consumer.accept(queue);
                queue.clear();
            }
        });
        if (queue.size() > 0) {
            consumer.accept(queue);
        }
        return result;
    }

    public <T> int consumeChunkedList(int chunkSize, Consumer<? super ImmutableList<T>> consumer) {
        return this.consumeChunked(chunkSize, l -> consumer.accept((Object)ImmutableList.copyOf((Collection)l)));
    }

    public <T> int consumeChunkedSet(int chunkSize, Consumer<? super ImmutableSet<T>> consumer) {
        return this.consumeChunked(chunkSize, l -> consumer.accept((Object)ImmutableSet.copyOf((Collection)l)));
    }

    public <O, K, V> int consumeChunkedMap(int chunkSize, Function<? super O, K> keyFunction, Function<? super O, V> valueFunction, Consumer<? super ImmutableMap<K, V>> consumer) {
        return this.consumeChunked(chunkSize, entries -> consumer.accept((Object)entries.stream().collect(ImmutableMap.toImmutableMap((Function)keyFunction, (Function)valueFunction))));
    }

    public <K, V> int consumeChunkedMap(int chunkSize, String keyProperty, String valueProperty, Consumer<? super ImmutableMap<K, V>> consumer) {
        return this.consumeChunkedMap(chunkSize, (Function)IbatisDAOUtil.singlePropertyFunction(keyProperty), (Function)IbatisDAOUtil.singlePropertyFunction(valueProperty), consumer);
    }
}

