/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractEmptyValueStringTypeHandlerCallback;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;

public class EmptyValueCLobTypeHandlerCallback
extends AbstractEmptyValueStringTypeHandlerCallback {
    public EmptyValueCLobTypeHandlerCallback() {
        super(String.class, 2005);
    }

    @Override
    protected String getValue(ResultGetter getter) throws SQLException {
        Reader cs = getter.getClob().getCharacterStream();
        try {
            String string = this.parseValue(IOUtils.toString((Reader)cs));
            return string;
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
        finally {
            IOUtils.closeQuietly((Reader)cs);
        }
    }

    @Override
    protected void setValue(ParameterSetter setter, String parameter) throws SQLException {
        if (parameter == null || parameter.length() == 0) {
            super.setValue(setter, parameter);
        } else {
            Clob clob = setter.getPreparedStatement().getConnection().createClob();
            setter.setClob(clob);
            Writer writer = clob.setCharacterStream(0L);
            try {
                writer.append(parameter);
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }
}

