/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractTypeHandlerCallback;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypes;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentTypeTypeHandlerCallback
extends AbstractTypeHandlerCallback<ComponentType> {
    public ComponentTypeTypeHandlerCallback() {
        super(ComponentType.class, 12);
    }

    @Override
    protected void setValue(ParameterSetter setter, ComponentType parameter) throws SQLException {
        setter.setString(ComponentTypeTypeHandlerCallback.componentTypeToString(parameter));
    }

    @Nonnull
    @VisibleForTesting
    static String componentTypeToString(@Nonnull ComponentType parameter) {
        return parameter.getSqlString();
    }

    @Override
    protected ComponentType parseValue(String s) {
        return ComponentTypeTypeHandlerCallback.parseCompentType(s);
    }

    @CheckForNull
    @VisibleForTesting
    static ComponentType parseCompentType(@Nullable String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        int splitAt = s.indexOf(35);
        if (splitAt < 0) {
            return ComponentTypes.valueOf(s, null);
        }
        return ComponentTypes.valueOf(s.substring(0, splitAt), s.substring(splitAt + 1));
    }

    @Override
    protected ComponentType getValue(ResultGetter getter) throws SQLException {
        return ComponentTypeTypeHandlerCallback.parseCompentType(getter.getString());
    }
}

