/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractTypeHandlerCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.SQLException;

public class CharBooleanTypeHandlerCallback
extends AbstractTypeHandlerCallback<Boolean> {
    private static final char YES = 't';
    private static final char NO = 'f';
    private static final String YES_STRING = new String(new char[]{'t'});
    private static final String NO_STRING = new String(new char[]{'f'});

    public CharBooleanTypeHandlerCallback() {
        super(Boolean.class, 1);
    }

    @Override
    protected void setValue(ParameterSetter setter, Boolean parameter) throws SQLException {
        if (parameter == null) {
            setter.setString(null);
        } else {
            setter.setString(parameter != false ? YES_STRING : NO_STRING);
        }
    }

    @Override
    protected Boolean parseValue(String s) {
        return s == null ? Boolean.FALSE : Boolean.valueOf(s.length() > 0 && s.toLowerCase().charAt(0) == 't');
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="this is a type handler, we translate and null is null!")
    protected Boolean getValue(ResultGetter getter) throws SQLException {
        String s = getter.getString();
        return s != null ? this.parseValue(s) : null;
    }
}

