/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractDriverSpecificTypeHandler;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractUUIDTypeHandlerCallback<T>
extends AbstractDriverSpecificTypeHandler<T> {
    private static final int UUID_BYTES = 16;

    protected AbstractUUIDTypeHandlerCallback(Class<T> clz) {
        super(clz, -2, -3);
    }

    @Override
    protected void setValueOracle(ParameterSetter setter, T id) throws SQLException {
        setter.setBytes(AbstractUUIDTypeHandlerCallback.toByteArray(this.getUUID(id)));
    }

    @Override
    protected void setValuePostgres(ParameterSetter setter, T parameter) throws SQLException {
        setter.setObject((Object)this.getUUID(parameter));
    }

    @Override
    protected T parseValue(String s) {
        return this.createId(UUID.fromString(s));
    }

    @Nonnull
    protected abstract T createId(UUID var1);

    @Nonnull
    protected abstract UUID getUUID(T var1);

    @Override
    protected T getValueOracle(ResultGetter getter) throws SQLException {
        byte[] bytes = getter.getBytes();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return this.createId(new UUID(mostSignificantBits, leastSignificantBits));
    }

    @Override
    protected T getValuePostgres(ResultGetter getter) throws SQLException {
        return this.createId((UUID)getter.getObject());
    }

    @Nonnull
    private static byte[] toByteArray(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }
}

