/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractTypeHandlerCallback;
import java.sql.SQLException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEnumTypeHandlerCallback<T extends Comparable<?>, E extends Enum<?>>
extends AbstractTypeHandlerCallback<E> {
    private final ImmutableMap<T, E> _mappedValues;
    private final Logger _logger = LoggerFactory.getLogger(AbstractEnumTypeHandlerCallback.class);

    protected AbstractEnumTypeHandlerCallback(@Nonnull Class<E> clz, int sqlType) {
        super(clz, sqlType);
        this._mappedValues = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])((Enum[])clz.getEnumConstants())), (Function)new Function<E, T>(){

            public T apply(E input) {
                return AbstractEnumTypeHandlerCallback.this.getWrappedValue(input);
            }
        });
    }

    @Nonnull
    protected abstract T getWrappedValue(@Nonnull E var1);

    @Override
    protected final void setValue(ParameterSetter setter, E parameter) throws SQLException {
        this.setWrappedValue(setter, this.getWrappedValue(parameter));
    }

    protected abstract void setWrappedValue(@Nonnull ParameterSetter var1, @Nonnull T var2) throws SQLException;

    @Override
    protected final E parseValue(String s) {
        return this.fromMap(this.wrappedValueOf(s));
    }

    @CheckForNull
    private E fromMap(@Nullable T representation) {
        if (representation == null || StringUtils.isEmpty((String)representation.toString())) {
            return null;
        }
        Enum result = (Enum)this._mappedValues.get(representation);
        if (result == null) {
            String errorMessage = "Unknown enum representation for type " + this._clz.getSimpleName() + ": " + representation;
            this._logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        return (E)result;
    }

    @CheckForNull
    protected abstract T wrappedValueOf(@Nonnull String var1);

    @Override
    protected final E getValue(ResultGetter getter) throws SQLException {
        T wrappedValue = this.getWrappedValue(getter);
        return getter.wasNull() ? null : (E)this.fromMap(wrappedValue);
    }

    @CheckForNull
    protected abstract T getWrappedValue(@Nonnull ResultGetter var1) throws SQLException;
}

