/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractTypeHandlerCallback;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public abstract class AbstractEmptyValueStringTypeHandlerCallback
extends AbstractTypeHandlerCallback<String> {
    private static final String DB_EMPTY_STRING = "$EMPTY$";
    private static final String EMPTY_STRING = "";

    protected AbstractEmptyValueStringTypeHandlerCallback(@Nonnull Class<String> clz, int sqlType) {
        super(clz, sqlType);
    }

    @Override
    protected void setValue(ParameterSetter setter, String parameter) throws SQLException {
        if (parameter == null) {
            setter.setString(null);
        } else if (parameter.isEmpty()) {
            setter.setString(DB_EMPTY_STRING);
        } else {
            setter.setString(parameter);
        }
    }

    @Override
    protected String parseValue(String s) {
        return DB_EMPTY_STRING.equals(s) ? EMPTY_STRING : s;
    }
}

