/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.integration.persistence.ibatis;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import de.justsoftware.onx.common.integration.persistence.ibatis.AbstractTypeHandlerCallback;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractDriverSpecificTypeHandler<T>
extends AbstractTypeHandlerCallback<T> {
    private static final ThreadLocal<DBType> DB_TYPE_HOLDER = new ThreadLocal();
    private final DBType _dbType;

    protected AbstractDriverSpecificTypeHandler(Class<T> clz, int sqlTypePostgres, int sqlTypeOracle) {
        this(clz, sqlTypePostgres, sqlTypeOracle, DB_TYPE_HOLDER.get());
    }

    private AbstractDriverSpecificTypeHandler(Class<T> clz, int sqlTypePostgres, int sqlTypeOracle, DBType dbType) {
        super(clz, AbstractDriverSpecificTypeHandler.selectSqlType(dbType, sqlTypePostgres, sqlTypeOracle));
        this._dbType = dbType;
    }

    private static int selectSqlType(@Nullable DBType dbType, int sqlTypePostgres, int sqlTypeOracle) {
        if (dbType != null) {
            switch (dbType) {
                case POSTGRES: {
                    return sqlTypePostgres;
                }
                case ORACLE: {
                    return sqlTypeOracle;
                }
            }
        }
        throw new IllegalArgumentException("Unhandled database type: " + dbType);
    }

    public static void setDBType(@Nullable String dbType) {
        if (dbType == null) {
            DB_TYPE_HOLDER.set(null);
            return;
        }
        switch (dbType) {
            case "postgresql": {
                DB_TYPE_HOLDER.set(DBType.POSTGRES);
                return;
            }
            case "oracle": {
                DB_TYPE_HOLDER.set(DBType.ORACLE);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + dbType);
    }

    @Override
    protected void setValue(ParameterSetter setter, T parameter) throws SQLException {
        switch (this._dbType) {
            case ORACLE: {
                this.setValueOracle(setter, parameter);
                return;
            }
            case POSTGRES: {
                this.setValuePostgres(setter, parameter);
                return;
            }
        }
        this.throwUnsupported();
    }

    @Override
    protected T getValue(ResultGetter getter) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        switch (this._dbType) {
            case ORACLE: {
                return this.getValueOracle(getter);
            }
            case POSTGRES: {
                return this.getValuePostgres(getter);
            }
        }
        return this.throwUnsupported();
    }

    protected abstract void setValueOracle(ParameterSetter var1, T var2) throws SQLException;

    protected abstract void setValuePostgres(ParameterSetter var1, T var2) throws SQLException;

    @CheckForNull
    protected abstract T getValueOracle(ResultGetter var1) throws SQLException;

    @CheckForNull
    protected abstract T getValuePostgres(ResultGetter var1) throws SQLException;

    @Nonnull
    private T throwUnsupported() {
        throw new UnsupportedOperationException("bahavior for " + this._dbType + " not defined");
    }

    public static enum DBType {
        POSTGRES,
        ORACLE;

    }
}

