/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.deletion.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteActionDescriptor;
import de.justsoftware.onx.common.deletion.model.DeleteActionId;
import de.justsoftware.onx.common.deletion.persistence.DeleteActionDAO;
import de.justsoftware.onx.common.deletion.persistence.ibatis.DBDeleteAction;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisDeleteActionDAO
implements DeleteActionDAO {
    private final IbatisStatementBuilder _ibatisStatementBuilder;
    private final Clock _clock;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisDeleteActionDAO(StatementBuilderFactory statementBuilderFactory, Clock clock) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("DeleteAction");
        this._clock = clock;
    }

    @Override
    public DeleteActionId create(ItemId itemToDeleteId, PersonId actorId, DeleteActionDescriptor descriptor, boolean archiveData) {
        return this.create(itemToDeleteId, actorId, descriptor, archiveData, this._clock.now());
    }

    @Override
    public DeleteActionId create(ItemId itemToDeleteId, PersonId actorId, DeleteActionDescriptor descriptor, boolean archiveData, DateTime deletedAt) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("personId", actorId);
        param.put("itemId", itemToDeleteId);
        param.put("descriptor", (Object)descriptor);
        param.put("archiveData", archiveData);
        param.put("deletedAt", deletedAt);
        return (DeleteActionId)this._ibatisStatementBuilder.insertDbSpecific("insert").param(param).get();
    }

    @Override
    public DeleteAction getById(DeleteActionId id) {
        return this.toDeleteAction((DBDeleteAction)this._ibatisStatementBuilder.select("selectById").param(id).asObject());
    }

    @CheckForNull
    private DeleteAction toDeleteAction(@Nullable DBDeleteAction actionModel) {
        return actionModel != null ? new DeleteAction(actionModel) : null;
    }

    @Override
    public void markDeleteActionAsFinished(DeleteActionId id) {
        this._ibatisStatementBuilder.update("markDeleteActionAsFinished").param(id);
    }

    @Override
    public DeleteAction getCurrentDeleteAction() {
        return this.toDeleteAction((DBDeleteAction)((IbatisStandardResultBuilder)this._ibatisStatementBuilder.selectDbSpecific("getCurrentDeleteAction").noParam()).asObject());
    }

    @Override
    public ImmutableList<DBDeleteAction> getByItemId(ItemId deletedItemId) {
        return this._ibatisStatementBuilder.select("selectByItemId").param(deletedItemId.asString()).asList();
    }

    @Override
    public int getNumberOfRecordsToDelete(DateTime deleteBeforeDate) {
        return this._ibatisStatementBuilder.select("getNumberOfRecordsToDelete").param(deleteBeforeDate).asCount();
    }

    @Override
    public int deleteOldRecords(DateTime deleteBeforeDate) {
        return this._ibatisStatementBuilder.delete("deleteOldRecords").param(deleteBeforeDate);
    }

    @Override
    public void delete(DeleteActionId deleteActionId) {
        this._ibatisStatementBuilder.delete("delete").param(deleteActionId);
    }
}

