/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.cache.AbstractSingleValueCacheAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractTableCacheAccessor<CN extends CacheName, R, C, V>
extends AbstractSingleValueCacheAccessor<CN, R, Map<C, V>> {
    protected AbstractTableCacheAccessor(@Nonnull CacheClient<? super CN> cache, @Nonnull CN name) {
        super(cache, name);
    }

    @Nonnull
    protected abstract Table<R, C, V> getFromDatabase(@Nonnull Set<? extends R> var1);

    @Nonnull
    public ImmutableTable<R, C, V> getTable(@Nonnull Set<? extends R> inputs) {
        if (this.isPassThrough(inputs)) {
            return ImmutableTable.copyOf(this.getFromDatabase(inputs));
        }
        Map cacheResults = this._cache.getBulk(this._name, (Collection<String>)this.createKeys(inputs));
        ImmutableTable.Builder result = ImmutableTable.builder();
        ImmutableSet.Builder missingKeysBuilder = ImmutableSet.builder();
        for (R input : inputs) {
            String key = this.keyToString(input);
            Object cachedResult = cacheResults.get(key);
            if (cachedResult == null) {
                missingKeysBuilder.add(input);
                continue;
            }
            if (CacheClient.NULL.equals(cachedResult)) continue;
            for (Map.Entry entry : ((Map)this.castAndCopy(cachedResult)).entrySet()) {
                result.put(input, entry.getKey(), entry.getValue());
            }
        }
        ImmutableSet missingKeys = missingKeysBuilder.build();
        if (!missingKeys.isEmpty()) {
            Table<R, C, V> dbResults = this.getFromDatabase((Set<? extends R>)missingKeys);
            for (Object input : missingKeys) {
                ImmutableMap dbResult = ImmutableMap.copyOf((Map)dbResults.row(input));
                this.putIntoCache(input, dbResult);
                for (Map.Entry entry : dbResult.entrySet()) {
                    result.put(input, entry.getKey(), entry.getValue());
                }
            }
        }
        return result.build();
    }

    @Override
    @Nonnull
    public ImmutableMap<C, V> getSingle(R input) {
        return this.getTable((Set<? extends R>)ImmutableSet.of(input)).row(input);
    }

    @Override
    public final ImmutableMap<R, Map<C, V>> getMap(Set<? extends R> inputs) {
        return this.getTable(inputs).rowMap();
    }
}

