/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractMultiValueCacheAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractMultiMapCacheAccessor<C extends CacheName, I, O, T, M extends ImmutableMultimap<I, O>, B extends ImmutableMultimap.Builder<I, O>, IC extends ImmutableCollection<O>>
extends AbstractMultiValueCacheAccessor<C, I, O, IC> {
    protected AbstractMultiMapCacheAccessor(@Nonnull CacheClient<? super C> cache, @Nonnull C name) {
        super(cache, name);
    }

    @Override
    public final IC getSingle(I input) {
        return this.get(this.getMultiMap((Set<? extends I>)ImmutableSet.of(input)), input);
    }

    public final M getMultiMap(Set<? extends I> inputs) {
        if (this.isPassThrough(inputs)) {
            return this.loadFromDatabase(this.createBuilder(), inputs);
        }
        B result = this.createBuilder();
        Map cacheResults = this._cache.getBulk(this._name, (Collection<String>)this.createKeys(inputs));
        ImmutableSet.Builder missingKeysBuilder = ImmutableSet.builder();
        for (I input : inputs) {
            String key = this.keyToString(input);
            Object cachedResult = cacheResults.get(key);
            if (cachedResult == null) {
                missingKeysBuilder.add(input);
                continue;
            }
            if (CacheClient.NULL.equals(cachedResult)) continue;
            result.putAll(input, this.castAndCopy(cachedResult));
        }
        ImmutableSet missingKeys = missingKeysBuilder.build();
        M finalResult = this.loadFromDatabase(result, (Set<? extends I>)missingKeys);
        for (Object input : missingKeys) {
            this.putIntoCache(input, this.get(finalResult, input));
        }
        return finalResult;
    }

    @Nonnull
    private M loadFromDatabase(@Nonnull B resultBuilder, @Nonnull Set<? extends I> missingKeys) {
        if (!missingKeys.isEmpty()) {
            Iterable<T> dbResults = this.getListFromDatabase(missingKeys);
            for (T dbResult : dbResults) {
                O objectToValue;
                I key;
                if (dbResult == null || (key = this.objectToKey(dbResult)) == null || (objectToValue = this.objectToValue(dbResult)) == null) continue;
                resultBuilder.putAll(key, this.copyCollection(ImmutableList.of(objectToValue)));
            }
        }
        return this.build(resultBuilder);
    }

    @CheckForNull
    protected abstract O objectToValue(@Nonnull T var1);

    @Nonnull
    protected abstract IC get(@Nonnull M var1, @Nonnull I var2);

    @Nonnull
    protected abstract M build(@Nonnull B var1);

    @Nonnull
    protected abstract B createBuilder();

    @CheckForNull
    protected abstract I objectToKey(@Nonnull T var1);

    @Nonnull
    protected abstract Iterable<? extends T> getListFromDatabase(@Nonnull Set<? extends I> var1);
}

