/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.TrueFuture;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.common.fastcopy.FastCopyUtils;
import de.justsoftware.onx.common.cache.CacheAccessor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCacheAccessor<C extends CacheName, I, O>
implements CacheAccessor<I, O> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCacheAccessor.class);
    protected final CacheClient<? super C> _cache;
    protected final C _name;
    private int _passThroughLimit;

    AbstractCacheAccessor(@Nonnull CacheClient<? super C> cache, @Nonnull C name) {
        this._cache = cache;
        this._name = name;
        this._passThroughLimit = name instanceof EhCacheName ? ((EhCacheName)name).getPassThroughLimit() : 1000;
    }

    protected boolean isPassThrough(@Nonnull Iterable<? extends I> keys) {
        return Iterables.size(keys) > this._passThroughLimit;
    }

    @Override
    public final Future<Boolean> invalidateKey(I key) {
        return this._cache.delete(this._name, this.keyToString(key));
    }

    @Override
    public final void invalidateKeyAndWait(I key) {
        try {
            this.invalidateKey(key).get();
        }
        catch (InterruptedException e) {
            return;
        }
        catch (ExecutionException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public final Future<Boolean> invalidateKeys(Iterable<? extends I> keys) {
        if (this._cache.isDeleteAllByCacheNameAllowed() && this.isPassThrough(keys)) {
            this._cache.deleteAll(this._name);
            return TrueFuture.INSTANCE;
        }
        return this._cache.deleteKeys(this._name, (Iterable<String>)this.createKeys((Iterable<? extends I>)ImmutableSet.copyOf(keys)));
    }

    @Override
    public final void invalidateKeysAndWait(Iterable<? extends I> keys) {
        try {
            this.invalidateKeys(keys).get();
        }
        catch (InterruptedException e) {
            return;
        }
        catch (ExecutionException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void invalidateAll() {
        this._cache.deleteAll(this._name);
    }

    @Nonnull
    protected final ImmutableSet<String> createKeys(@Nonnull Iterable<? extends I> keys) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (I key : keys) {
            if (key == null) continue;
            result.add((Object)this.keyToString(key));
        }
        return result.build();
    }

    @Nonnull
    protected abstract String keyToString(@Nonnull I var1);

    @Nonnull
    protected static <T> T fastCopy(@Nonnull T o) {
        try {
            return FastCopyUtils.copy(o);
        }
        catch (FastCopyUtils.FastCopyException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

