/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.cache;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.cache.AbstractMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.BiDirectionalCacheAccessor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBiDirectionalCacheAccessor<C extends CacheName, I extends Serializable, T>
extends AbstractMultiMapCacheAccessor<C, I, I, T, ImmutableSetMultimap<I, I>, ImmutableSetMultimap.Builder<I, I>, ImmutableSet<I>>
implements BiDirectionalCacheAccessor<I> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBiDirectionalCacheAccessor.class);

    protected AbstractBiDirectionalCacheAccessor(@Nonnull CacheClient<? super C> cache, @Nonnull C name) {
        super(cache, name);
    }

    @Override
    protected final ImmutableSet<I> get(ImmutableSetMultimap<I, I> map, I input) {
        return map.get(input);
    }

    @Override
    protected final ImmutableSetMultimap<I, I> build(ImmutableSetMultimap.Builder<I, I> builder) {
        return builder.build();
    }

    @Override
    protected final ImmutableSetMultimap.Builder<I, I> createBuilder() {
        return ImmutableSetMultimap.builder();
    }

    @Override
    public final boolean isInRelation(I input1, I input2) {
        if (input1.equals(input2)) {
            return ((ImmutableSet)this.getSingle(input1)).contains(input2);
        }
        String key1 = this.keyToString(input1);
        String key2 = this.keyToString(input2);
        Map cacheResults = this._cache.getBulk(this._name, (Collection<String>)ImmutableSet.of((Object)key1, (Object)key2));
        ImmutableSet cached1 = (ImmutableSet)cacheResults.get(key1);
        ImmutableSet cached2 = (ImmutableSet)cacheResults.get(key2);
        if (cached1 != null && cached2 != null) {
            boolean result2;
            boolean result1 = cached1.contains(input2);
            if (result1 != (result2 = cached2.contains(input1))) {
                this.error("Cache \"{}\" will not work properly because cache request returned unexpected results:\n{}: {}\n{}: {}", new Object[]{this._name, input1, cached1, input2, cached2});
            }
            return result1;
        }
        if (cached1 != null) {
            return cached1.contains(input2);
        }
        if (cached2 != null) {
            return cached2.contains(input1);
        }
        return this.loadFromDatabaseAndPutIntoCache(input1, input2);
    }

    @VisibleForTesting
    protected void error(@Nonnull String message, @Nonnull Object[] parameter) {
        LOG.error(message, parameter);
    }

    private boolean loadFromDatabaseAndPutIntoCache(@Nonnull I input1, @Nonnull I input2) {
        boolean result2;
        ImmutableSet.Builder loaded1Builder = ImmutableSet.builder();
        ImmutableSet.Builder loaded2Builder = ImmutableSet.builder();
        Iterable dbResults = this.getListFromDatabase(ImmutableSet.of(input1, input2));
        for (Object dbResult : dbResults) {
            Serializable value;
            Serializable key;
            if (dbResult == null || (key = (Serializable)this.objectToKey(dbResult)) == null || (value = (Serializable)this.objectToValue(dbResult)) == null) continue;
            if (input1.equals(key)) {
                loaded1Builder.add((Object)value);
            }
            if (!input2.equals(key)) continue;
            loaded2Builder.add((Object)value);
        }
        ImmutableSet loaded1 = loaded1Builder.build();
        ImmutableSet loaded2 = loaded2Builder.build();
        boolean result1 = loaded1.contains(input2);
        if (result1 != (result2 = loaded2.contains(input1))) {
            this.error("Cache \"{}\" will not work properly because database request returned unexpected results:\n{}: {}\n{}: {}", new Object[]{this._name, input1, loaded1, input2, loaded2});
        } else {
            this.putIntoCache(input1, loaded1);
            this.putIntoCache(input2, loaded2);
        }
        return result1;
    }
}

