/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.google.common.base.Function;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class ServerDateFormatter
implements DateFormatter {
    private static final NullPermeableFunction<BasicConstants, String> DATE_FORMAT = new NullPermeableFunction<BasicConstants, String>(){

        @Override
        protected String applySafe(BasicConstants input) {
            return input.dateFormat();
        }
    };
    private static final NullPermeableFunction<BasicConstants, String> TIME_FORMAT = new NullPermeableFunction<BasicConstants, String>(){

        @Override
        protected String applySafe(BasicConstants input) {
            return input.timeFormat();
        }
    };
    private static final NullPermeableFunction<BasicConstants, String> DATE_TIME_FORMAT = new NullPermeableFunction<BasicConstants, String>(){

        @Override
        protected String applySafe(BasicConstants input) {
            return input.dateTimeFormat();
        }
    };
    private static final NullPermeableFunction<BasicConstants, String> DATE_NO_YEAR_FORMAT = new NullPermeableFunction<BasicConstants, String>(){

        @Override
        protected String applySafe(BasicConstants input) {
            return input.dateFormatNoYear();
        }
    };
    private final ServerLocalizedMessages _localizedMessages;
    private final Locale _locale;
    private final DateTimeZone _timeZone;

    public ServerDateFormatter(@Nonnull ServerLocalizedMessages localizedMessages, @Nullable DateTimeZone timeZone) {
        this._localizedMessages = localizedMessages;
        this._timeZone = timeZone;
        this._locale = new Locale(localizedMessages.getLocale());
    }

    @Override
    public String formatDate(Date date) {
        return this.format(DATE_FORMAT, date);
    }

    @Nonnull
    private String format(@Nonnull Function<BasicConstants, String> f, @Nonnull Date date) {
        return DateTimeFormat.forPattern((String)((String)f.apply((Object)this._localizedMessages.basicConstants()))).withLocale(this._locale).withZone(this._timeZone).print((ReadableInstant)new DateTime((Object)date));
    }

    @Override
    public String formatTime(Date date) {
        return this.format(TIME_FORMAT, date);
    }

    @Override
    public String formatDateTime(Date date) {
        return this.format(DATE_TIME_FORMAT, date);
    }

    @Override
    public String formatDateNoYear(Date date) {
        return this.format(DATE_NO_YEAR_FORMAT, date);
    }
}

