/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.server.model.AlbumImageItem;
import de.justsoftware.onx.album.shared.server.model.AlbumItem;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.comments.shared.server.model.CommentItem;
import de.justsoftware.onx.common.business.BreadcrumbLinkService;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.container.shared.model.TenantItem;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.EntityVersionItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.container.shared.server.model.PseudoEntityItem;
import de.justsoftware.onx.document.shared.model.DocumentId;
import de.justsoftware.onx.document.shared.server.model.DocumentItem;
import de.justsoftware.onx.document.shared.server.model.DocumentVersionItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveShareItem;
import de.justsoftware.onx.drive.business.model.DriveTempItem;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.link.shared.server.model.LinkItem;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.raweditor.shared.server.model.RawEditorItem;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.server.model.SurveyItem;
import de.justsoftware.onx.tasks.authorization.model.TaskItem;
import de.justsoftware.onx.tasks.authorization.model.TaskListItem;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.videolink.shared.server.model.VideolinkItem;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiBackupItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiEditorItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiVersionItem;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.server.model.FeedItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="internalLinkService")
@ParametersAreNonnullByDefault
public class InternalLinkServiceImpl
implements InternalLinkService,
BreadcrumbLinkService {
    private static final String QUERY_PARAMETER_PREVIEW_DOCUMENT_ID = "previewDocumentId";
    private static final String QUERY_PARAMETER_PREVIEW_PARENT_ID = "previewParentId";
    @Autowired
    @VisibleForTesting
    ItemService _itemService;
    @Autowired
    @VisibleForTesting
    ServerUrlUtil _serverUrlUtil;
    @Autowired
    @VisibleForTesting
    I18nService _i18nService;
    @Autowired
    @VisibleForTesting
    PersonService _personService;
    @Autowired
    @VisibleForTesting
    EntityConfigService _entityConfigService;
    @Autowired
    @VisibleForTesting
    WorkstreamDataService _workstreamDataService;

    @Nonnull
    private Link makeAbsolute(Link link) {
        link.setHref(this.makeURL(link.getHrefOrEmpty()));
        return link;
    }

    @Override
    public String makeURL(String token) {
        return this.makeAbsolute(token);
    }

    @Override
    public String makePath(String token) {
        Object hashedToken = token.startsWith("#") ? token : "#" + token;
        return "/toro/resource/html" + (String)hashedToken;
    }

    @Override
    public String addHost(String path) {
        Object pathWithSlash = path.startsWith("/") ? path : "/" + path;
        return InternalLinkServiceImpl.hostWithContextPath(this._serverUrlUtil) + (String)pathWithSlash;
    }

    @Override
    public String makeAbsolute(String token) {
        Object hashedToken = token.startsWith("#") ? token : "#" + token;
        return this.addHost("/resource/html" + (String)hashedToken);
    }

    @Nonnull
    @VisibleForTesting
    static String hostWithContextPath(ServerUrlUtil serverUrlUtil) {
        String basePath = serverUrlUtil.getSystemDomainPrefix();
        return basePath + "/toro";
    }

    @Override
    public Link linkToItem(Item<?> item, AuthorizationCheckContextWithLocale authorizationContext) {
        Optional<Link> result = item.accept(new LinkVisitor(authorizationContext));
        if (!result.isPresent()) {
            throw new IllegalStateException("Breadcrumb service did not return a result for given item");
        }
        return (Link)result.get();
    }

    @Nonnull
    private String createUrlForTokenIdAndParams(InternalLinkService.LinkType linkType, HistoryToken tokenId, String paramType, Object ... params) {
        String token = TokenUtilServer.createToken(tokenId, paramType, params);
        return this.createUrlForToken(linkType, token);
    }

    @Nonnull
    private String createUrlForToken(InternalLinkService.LinkType linkType, String token) {
        switch (linkType) {
            case URL: {
                return this.makeURL(token);
            }
            case PATH: {
                return this.makePath(token);
            }
            case FRAGMENT: {
                return "#" + token;
            }
        }
        throw new IllegalArgumentException("LinkType " + linkType + " is unknown");
    }

    @Override
    public Link linkToItemAbsolute(Item<?> item, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.makeAbsolute(this.linkToItem(item, authorizationContext));
    }

    @Override
    public String getImageUrl(AlbumImageId albumImageId, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.MDL_IMAGE, "LL", albumImageId);
    }

    @Override
    public String getAlbumUrl(AlbumId albumId, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.MDL_ALBUM, "L", albumId);
    }

    @Override
    public String getProfileUrl(PersonId personId, InternalLinkService.LinkType linkType) {
        if (personId == null) {
            return null;
        }
        DBPerson person = this._personService.getPersonById(personId);
        return this.getProfileUrl(person, linkType);
    }

    @Override
    public String getProfileUrl(DBPerson person, InternalLinkService.LinkType linkType) {
        if (person == null || person.isDeleted()) {
            return null;
        }
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.PROFILE, "L", person.getId());
    }

    @Override
    public String getEntityUrl(EntityId entityId, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.ENTITY, "L", entityId);
    }

    @Override
    public String getDocumentUrl(DocumentId doc, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.MDL_DOCUMENT, "L", doc);
    }

    @Override
    public String getWorkstreamAttachmentUrl(final WorkstreamMessageId workstreamMessageId, JCMediaContentId id) {
        return id.accept(new JCMediaContentId.Visitor<String>(){

            @Override
            public String visit(VideolinkId videolinkId) {
                return "";
            }

            @Override
            public String visit(AlbumImageId albumImageId) {
                return "";
            }

            @Override
            public String visit(DriveDocumentId driveDocumentId) {
                String tokenForWorkstreamMessage = TokenUtilServer.createToken(HistoryToken.WORKSTREAM_ITEM, "L", workstreamMessageId);
                String tokenForPreview = String.format("%s?%s=%s&%s=%s", tokenForWorkstreamMessage, InternalLinkServiceImpl.QUERY_PARAMETER_PREVIEW_DOCUMENT_ID, driveDocumentId.getId(), InternalLinkServiceImpl.QUERY_PARAMETER_PREVIEW_PARENT_ID, TokenUtilServer.encodeParam(workstreamMessageId.toItemId().asString()));
                return InternalLinkServiceImpl.this.createUrlForToken(InternalLinkService.LinkType.URL, tokenForPreview);
            }
        });
    }

    @Override
    public String getVideoUrl(VideolinkId id, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.MDL_VIDEO_LINK, "L", id);
    }

    @Override
    public String getUrlForMicroblogEntry(WorkstreamMessageId id, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.WORKSTREAM_ITEM, "L", id);
    }

    @Override
    public String getSurveyUrl(SurveyId surveyId, InternalLinkService.LinkType linkType) {
        return this.createUrlForTokenIdAndParams(linkType, HistoryToken.SURVEY, "L", surveyId);
    }

    @Override
    public Link link(AlbumItem item, LocalizedMessages localizedMessages) {
        String title = item.getAlbum().getTitle();
        String text = StringUtils.isEmpty((String)title) ? localizedMessages.albumConstants().album() : title;
        return new Link(text, this.getAlbumUrl(item.getId(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(AlbumImageItem item, LocalizedMessages localizedMessages) {
        String title = item.getAlbumImage().getTitle();
        String text = StringUtils.isEmpty((String)title) ? localizedMessages.albumConstants().picture() : title;
        return new Link(text, this.getImageUrl(item.getId(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(EntityItem item) {
        return new Link(item.getEntity().getName(), this.getEntityUrl(item.getId(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(ProfileItem profileItem) {
        return new Link(this._personService.getAnnotatedName(profileItem.getPerson()).toString(), this.getProfileUrl(profileItem.getPerson(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(SurveyItem item) {
        return new Link(item.getSurvey().getTitle(), this.getSurveyUrl(item.getId(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(VideolinkItem item) {
        return new Link(item.getLink().getTitle(), this.getVideoUrl(item.getId(), InternalLinkService.LinkType.FRAGMENT));
    }

    @Override
    public Link link(WorkstreamItem workstreamMessage, LocalizedMessages localizedMessages, AuthorizationCheckContextWithLocale authorizationContext) {
        String text;
        String string = text = workstreamMessage.getType() == WorkstreamMessageType.MICROBLOG_POSTING ? localizedMessages.workstreamConstants().microblogPosting() : localizedMessages.workstreamConstants().activityMessage();
        if (authorizationContext.may((Item<?>)workstreamMessage, (Action)StaticAction.WORKSTREAM_READ)) {
            return new Link(text, this.getUrlForMicroblogEntry((WorkstreamMessageId)workstreamMessage.getId(), InternalLinkService.LinkType.FRAGMENT));
        }
        return new Link(text, null);
    }

    @Override
    public String makeRelativeUrlAbsolute(String url) throws MalformedURLException {
        return new URL(new URL(this._serverUrlUtil.getDynamicResourcePrefixWithSystemDomain()), url).toExternalForm();
    }

    @Override
    public String getDriveDocumentUrl(DriveDocumentId documentId, InternalLinkService.LinkType linkType) {
        Item<DriveDocumentId> item = this._itemService.getById(documentId);
        if (item == null) {
            return "";
        }
        return this.getDriveDocumentUrl((DriveDocumentItem)item, linkType);
    }

    @Override
    public String getDriveDocumentUrl(DriveDocumentItem document, InternalLinkService.LinkType linkType) {
        ItemId contextParentId = this.getContextItemId(document);
        if (contextParentId instanceof EntityId) {
            return this.createUrlForTokenIdAndParams(linkType, HistoryToken.ENTITY, "LSSSLSLS", contextParentId, StaticEntityTab.DOCUMENTS.getName(), null, null, null, null, contextParentId, "/file/" + document.getId().getId()).replaceAll("%2F", "/");
        }
        return this.createUrlForToken(linkType, "/drive/file/" + document.getId().getId());
    }

    @Nonnull
    private ItemId getContextItemId(DriveDocumentItem item) {
        WorkstreamMessageId messageId;
        DBWorkstreamMessage message;
        if (item.getParentId() instanceof WorkstreamMessageId && (message = (DBWorkstreamMessage)this._workstreamDataService.getEntries((Set<WorkstreamMessageId>)ImmutableSet.of((Object)(messageId = (WorkstreamMessageId)item.getParentId()))).get((Object)messageId)) != null) {
            return message.getOriginItemId();
        }
        return item.getParentId();
    }

    @Override
    public String getDriveDocumentCommentsUrl(DriveDocumentItem document, InternalLinkService.LinkType linkType) {
        return this.getDriveDocumentUrl(document, linkType) + "/comments";
    }

    private class LinkVisitor
    implements ItemVisitor<Optional<Link>> {
        private final AuthorizationCheckContextWithLocale _authorizationContext;
        private final LocalizedMessages _localizedMessages;

        public LinkVisitor(AuthorizationCheckContextWithLocale authorizationContext) {
            this._authorizationContext = authorizationContext;
            this._localizedMessages = InternalLinkServiceImpl.this._i18nService.getLocalizedMessages(authorizationContext.getLocale());
        }

        @Override
        public Optional<Link> visit(AlbumItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.ALBUM_READ)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(item, this._localizedMessages));
        }

        @Override
        public Optional<Link> visit(AlbumImageItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.ALBUM_READ)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(item, this._localizedMessages));
        }

        @Override
        public Optional<Link> visit(CommentItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(EntityItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticEntityAction.ENTITY_READ_DETAILS)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(item));
        }

        @Override
        public Optional<Link> visit(DocumentItem item) {
            return this.notVisibleItem();
        }

        @Override
        public Optional<Link> visit(DocumentVersionItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(ProfileItem profileItem) {
            if (!this._authorizationContext.may(ProfileReadRole.of(profileItem.getId()))) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(profileItem));
        }

        @Override
        public Optional<Link> visit(StartpageItem item) {
            Item<ProfileId> profileItem = InternalLinkServiceImpl.this._itemService.getById(item.getId().asPersonId().asProfileId());
            if (profileItem == null) {
                return Optional.absent();
            }
            return profileItem.accept(this);
        }

        @Override
        public Optional<Link> visit(FeedItem item) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(RawEditorItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(SurveyItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.SURVEY_READ)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(item));
        }

        @Override
        public Optional<Link> visit(VideolinkItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.VIDEOLINK_READ)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)InternalLinkServiceImpl.this.link(item));
        }

        @Override
        public Optional<Link> visit(WikiBackupItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(WikiEditorItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(WikiVersionItem item) {
            return this.linktToParent(item);
        }

        @Override
        public Optional<Link> visit(WorkstreamItem workstreamMessage) {
            return Optional.of((Object)InternalLinkServiceImpl.this.link(workstreamMessage, this._localizedMessages, this._authorizationContext));
        }

        @Override
        public Optional<Link> visit(MultiWiki multiWiki) {
            return this.linktToParent(multiWiki);
        }

        @Override
        public Optional<Link> visit(MultiWikiVersion multiWikiVersion) {
            return this.linktToParent(multiWikiVersion);
        }

        @Override
        public Optional<Link> visit(MultiWikiVersionSection multiWikiSegment) {
            return this.linktToParent(multiWikiSegment);
        }

        @Override
        public Optional<Link> visit(EntityVersionItem entityVersionItem) {
            return this.linktToParent(entityVersionItem);
        }

        @Nonnull
        private Optional<Link> linktToParent(@Nonnull Item<?> item) {
            ItemId parentId = item.getParentId();
            if (parentId == null) {
                return Optional.absent();
            }
            Item<ItemId> parent = InternalLinkServiceImpl.this._itemService.getById(parentId);
            if (parent == null) {
                return Optional.absent();
            }
            return parent.accept(this);
        }

        @Nonnull
        private Optional<Link> notVisibleItem() {
            return Optional.of((Object)new Link(this._localizedMessages.basicConstants().secretItem(), null));
        }

        @Override
        public Optional<Link> visit(LinkItem link) {
            return Optional.of((Object)new Link(link.getTitle(), link.getUrl()));
        }

        @Override
        public Optional<Link> visit(Conversation conversation) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(ChatMessage message) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(ChatItem chatItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(PseudoEntityItem entityItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(DriveDocumentItem driveDocumentItem) {
            if (!this._authorizationContext.may((Item<?>)driveDocumentItem, (Action)StaticAction.DOCUMENT_READ)) {
                return this.notVisibleItem();
            }
            return Optional.of((Object)new Link(driveDocumentItem.getName(), InternalLinkServiceImpl.this.getDriveDocumentUrl(driveDocumentItem, InternalLinkService.LinkType.FRAGMENT)));
        }

        @Override
        public Optional<Link> visit(TaskItem taskItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(TaskListItem taskListItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(DriveShareItem driveShareItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(DriveTempItem driveTempItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(TenantItem tenantItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(WikiItem wikiItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(ChapterItem chapterItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(ArticleItem articleItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(PollItem pollItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(NewsPostItem newsPostItem) {
            return Optional.absent();
        }

        @Override
        public Optional<Link> visit(NewsChannelItem newsChannelItem) {
            return Optional.absent();
        }
    }
}

