/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.freiheit.superoperty.MetaProperty;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.event.SuperopertyChangeEvent;
import com.freiheit.superoperty.event.SuperopertyContainerListener;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.server.business.event.FlushCacheEvent;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.HostPropertiesLoader;
import de.justsoftware.onx.common.business.HostPropertiesReadDataService;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.profile.business.events.ProfileAttributeConfigurationChangedEvent;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HostPropertiesReadDataServiceImpl
implements ServerEventHandler,
HostPropertiesReadDataService,
SuperopertyContainerListener,
InitializingBean {
    private final HostPropertiesCacheAccessor _hostPropertiesCacheAccessor;
    private final SuperopertyContainer _settingsSuperopertyContainer;

    @Autowired
    public HostPropertiesReadDataServiceImpl(EhcacheClient cacheClient, HostPropertiesLoader hostPropertiesLoader, @Qualifier(value="settingsSuperopertyContainer") SuperopertyContainer settingsSuperopertyContainer) {
        this._hostPropertiesCacheAccessor = new HostPropertiesCacheAccessor(cacheClient, hostPropertiesLoader);
        this._settingsSuperopertyContainer = settingsSuperopertyContainer;
    }

    public void afterPropertiesSet() throws Exception {
        this._settingsSuperopertyContainer.addSuperopertyContainerListener((SuperopertyContainerListener)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConfigFileChanged(ConfigFileChangeEvent event) {
        this.invalidateAll();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onInvalidateHostPropertiesCacheEvent(FlushCacheEvent event) {
        this.invalidateAll();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onProfileAttributeConfigurationChangedEvent(ProfileAttributeConfigurationChangedEvent event) {
        this.invalidateAll();
    }

    public void metaPropertyDefined(SuperopertyContainer source, MetaProperty meta) {
    }

    public void anyPropertyChange(SuperopertyContainer source, SuperopertyChangeEvent event) {
        this.invalidateAll();
    }

    @Override
    public HostPropertiesBean getHostPropertiesForLocale(String locale) {
        HostPropertiesBean result = (HostPropertiesBean)this._hostPropertiesCacheAccessor.getSingle(locale);
        if (result == null) {
            throw new IllegalArgumentException("HostProperties for locale " + locale + " should have been found in cache or created!");
        }
        return result;
    }

    private void invalidateAll() {
        this._hostPropertiesCacheAccessor.invalidateAll();
    }

    @ParametersAreNonnullByDefault
    private static final class HostPropertiesCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<HostPropertiesEhCacheName, String, HostPropertiesBean> {
        private final HostPropertiesLoader _hostPropertiesLoader;

        private HostPropertiesCacheAccessor(EhcacheClient cache, HostPropertiesLoader hostPropertiesLoader) {
            super(cache, HostPropertiesEhCacheName.HOST_PROPERTIES);
            this._hostPropertiesLoader = hostPropertiesLoader;
        }

        @Override
        protected HostPropertiesBean getFromDatabaseSingle(String locale) {
            return this._hostPropertiesLoader.getHostPropertiesByLocale(locale);
        }

        @Override
        protected String keyToString(String key) {
            return key;
        }
    }

    @ParametersAreNonnullByDefault
    public static enum HostPropertiesEhCacheName implements EhCacheName
    {
        HOST_PROPERTIES{

            @Override
            public String getCacheName() {
                return "host.properties";
            }

            @Override
            public int getMaxElements() {
                return 25;
            }

            @Override
            public long getTimeToLiveSeconds() {
                return Integer.MAX_VALUE;
            }
        };

    }
}

