/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.google.common.collect.FluentIterable;
import de.justsoftware.onx.common.business.FileWatchService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class FileWatcherServiceImpl
implements FileWatchService {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcherServiceImpl.class);
    private static final long CHECK_INTERVALL_IN_MS = 60000L;
    private final List<FilesToWatch> _watches;
    private final JCEventBus _eventBus;

    @Autowired
    public FileWatcherServiceImpl(JCEventBus eventBus, @Qualifier(value="fileWatchScheduler") TaskScheduler taskScheduler) {
        this._eventBus = eventBus;
        this._watches = new ArrayList<FilesToWatch>();
        taskScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (FilesToWatch filesToWatch : FileWatcherServiceImpl.this._watches) {
                    FileWatcherServiceImpl.this.checkFilesChanged(filesToWatch);
                }
            }
        }, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFilesChanged(FilesToWatch filesToWatch) {
        long currentLastModified = 0L;
        boolean fileAddedOrRemoved = false;
        for (FileData file : filesToWatch.getFilesToWatch()) {
            InputStream in = null;
            try {
                Boolean exists;
                URLConnection conn = file.getUrl().openConnection();
                boolean fileExists = false;
                if (conn != null) {
                    conn.setUseCaches(false);
                    try {
                        in = conn.getInputStream();
                        if (conn.getLastModified() > currentLastModified) {
                            currentLastModified = conn.getLastModified();
                        }
                        fileExists = true;
                    }
                    catch (FileNotFoundException e) {
                        fileExists = false;
                    }
                }
                if ((exists = file.getFileExists()) != null && exists != fileExists) {
                    fileAddedOrRemoved = true;
                }
                file.setFileExists(fileExists);
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (IOException e) {
                LOG.error("Error while watching files - " + e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        if (fileAddedOrRemoved || currentLastModified > filesToWatch.getLastModified()) {
            filesToWatch.setLastModified(currentLastModified);
            LOG.info("File changed on the filesystem, raise event {}", (Object)filesToWatch.getEventToRaise().name());
            this._eventBus.post(filesToWatch.getEventToRaise());
        }
    }

    @Override
    public void registerWatchesFiles(List<URL> filesToWatch, FileWatchService.FileChangeEvent eventToRaise) {
        this._watches.add(new FilesToWatch(filesToWatch, eventToRaise));
    }

    @ParametersAreNonnullByDefault
    private static class FilesToWatch {
        private final List<FileData> _filesToWatch;
        private long _lastModified;
        private final FileWatchService.FileChangeEvent _eventToRaise;

        public FilesToWatch(List<URL> filesToWatch, FileWatchService.FileChangeEvent eventToRaise) {
            this._filesToWatch = FluentIterable.from(filesToWatch).transform(FileData.FROM_URL).toList();
            this._eventToRaise = eventToRaise;
            this._lastModified = System.currentTimeMillis();
        }

        @Nonnull
        public List<FileData> getFilesToWatch() {
            return this._filesToWatch;
        }

        @Nonnull
        public FileWatchService.FileChangeEvent getEventToRaise() {
            return this._eventToRaise;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(long lastModified) {
            this._lastModified = lastModified;
        }
    }

    @ParametersAreNonnullByDefault
    private static class FileData {
        private static final NullPermeableFunction<URL, FileData> FROM_URL = new NullPermeableFunction<URL, FileData>(){

            @Override
            protected FileData applySafe(URL input) {
                return new FileData(input);
            }
        };
        private final URL _url;
        private Boolean _fileExists;

        public FileData(URL url) {
            this._url = url;
        }

        @Nonnull
        public URL getUrl() {
            return this._url;
        }

        @CheckForNull
        public Boolean getFileExists() {
            return this._fileExists;
        }

        public void setFileExists(@Nullable Boolean fileExists) {
            this._fileExists = fileExists;
        }
    }
}

