/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.business.AntiSamyService;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

@Service
public class AntiSamyServiceImpl
implements AntiSamyService {
    private static final Logger LOG = LoggerFactory.getLogger(AntiSamyService.class);
    private static final String DEFAULT_ANTI_SAMY_POLICY_PATH = "classpath:etc/antisamy-policy.xml";
    private final AntiSamy _antiSamy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Autowired
    public AntiSamyServiceImpl(@Value(value="${antisamy.policy.path}") @Nullable String specificAntisamyPolicyPath, @Value(value="${imageServerUrl}") @Nonnull String imageServerUrl) throws PolicyException, TemplateException, IOException {
        InputStream templateStream = null;
        try {
            URL policyFile = AntiSamyServiceImpl.getPolicyFile(specificAntisamyPolicyPath);
            LOG.info(String.format("Loading antisamy policy from %s", policyFile.toString()));
            templateStream = AntiSamyServiceImpl.processAntiSamyTemplate(specificAntisamyPolicyPath, imageServerUrl);
            Policy policy = Policy.getInstance((InputStream)templateStream);
            this._antiSamy = new AntiSamy(policy);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(templateStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)templateStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static InputStream processAntiSamyTemplate(@Nullable String specificAntisamyPolicyPath, @Nonnull String imageServerUrl) throws TemplateException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream outStream = null;
        OutputStreamWriter outWriter = null;
        try {
            ByteArrayInputStream result;
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateLoader((TemplateLoader)new AntisamyTemplateLoader(specificAntisamyPolicyPath));
            Template template = cfg.getTemplate("does not matter");
            outStream = new ByteArrayOutputStream();
            outWriter = new OutputStreamWriter((OutputStream)outStream, Charsets.UTF_8);
            ImmutableMap rootMap = ImmutableMap.of((Object)"imageServerUrl", (Object)imageServerUrl);
            template.process((Object)rootMap, (Writer)outWriter);
            byteArrayInputStream = result = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outStream);
            IOUtils.closeQuietly(outWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outStream);
        IOUtils.closeQuietly((Writer)outWriter);
        return byteArrayInputStream;
    }

    @Nonnull
    private static URL getPolicyFile(@Nullable String specificAntisamyPolicyPath) throws FileNotFoundException {
        if (!Strings.isNullOrEmpty((String)specificAntisamyPolicyPath)) {
            try {
                URL url = ResourceUtils.getURL((String)specificAntisamyPolicyPath);
                if (!ResourceUtils.isFileURL((URL)url) || FileUtils.toFile((URL)url).exists()) {
                    return url;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            LOG.info(String.format("Failed to load specific antisamy policy file %s, using default policy file %s", specificAntisamyPolicyPath, DEFAULT_ANTI_SAMY_POLICY_PATH));
        }
        return ResourceUtils.getURL((String)DEFAULT_ANTI_SAMY_POLICY_PATH);
    }

    @Override
    public String checkAndCleanHtml(String html) {
        try {
            return this._antiSamy.scan(html).getCleanHTML().trim();
        }
        catch (ScanException e) {
            LOG.error("Failed to parse HTML", (Throwable)e);
            throw new ServiceException(e);
        }
        catch (PolicyException e) {
            LOG.error("Failed to parse the antisamy policy file", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Override
    public CleanResults scan(String html) throws ScanException, PolicyException {
        return this._antiSamy.scan(html);
    }

    private static class AntisamyTemplateLoader
    implements TemplateLoader {
        private final String _specificAntisamyPolicyPath;

        AntisamyTemplateLoader(@Nullable String specificAntisamyPolicyPath) {
            this._specificAntisamyPolicyPath = specificAntisamyPolicyPath;
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            return name;
        }

        public long getLastModified(Object templateSource) {
            return System.currentTimeMillis();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return new InputStreamReader(AntiSamyServiceImpl.getPolicyFile(this._specificAntisamyPolicyPath).openStream(), Charsets.UTF_8);
        }
    }
}

