/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.base.Strings;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathElement;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class ConfPathElement
extends ConfFileNode
implements PathElement<ImmutableBoolContext> {
    private final String _word;
    private final BoolExpr _condition;
    private final Object[] _hashObjects;

    public ConfPathElement(@Nullable ConfFilePosition pos, @Nullable String word, @Nullable BoolExpr condition) {
        super(pos);
        this._word = Strings.nullToEmpty((String)word);
        this._condition = condition != null ? condition : BoolExpr.trueConst(pos);
        this._hashObjects = new Object[]{this._word, this._condition};
    }

    public ConfPathElement(@Nullable ConfFilePosition pos, @Nullable String word) {
        this(pos, word, null);
    }

    @Override
    public String getWord() {
        return this._word;
    }

    @Override
    public boolean test(ImmutableBoolContext context) {
        return this._condition.eval(context);
    }

    public int hashCode() {
        return Arrays.hashCode(this._hashObjects);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ConfPathElement && Arrays.equals(this._hashObjects, ((ConfPathElement)obj)._hashObjects);
    }

    public String toString() {
        return "PathElement [" + this._word + "]";
    }
}

