/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfPathElement;
import de.justsoftware.onx.common.business.configfile.parser.ConfStatement;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfOptionsFor
extends ConfStatement {
    public static final Function<ConfOptionsFor, Iterable<ConfOption>> GET_CONF_OPTIONS = new NullPermeableFunction<ConfOptionsFor, Iterable<ConfOption>>(){

        @Override
        protected Iterable<ConfOption> applySafe(ConfOptionsFor confOptionsFor) {
            return confOptionsFor.getOptions().values();
        }
    };
    private final List<ConfPathElement> _path;
    private final ImmutableMap<String, ConfOption> _options;

    public ConfOptionsFor(@Nullable ConfFilePosition pos, @Nonnull List<ConfPathElement> path, @Nonnull Iterable<ConfOption> options) {
        super(pos);
        this._path = path;
        try {
            this._options = Maps.uniqueIndex(options, ConfOption.GET_OPTION_NAME);
        }
        catch (RuntimeException e) {
            throw new LoadConfigFileException(pos, (Throwable)e);
        }
    }

    @Nonnull
    public List<ConfPathElement> getPath() {
        return this._path;
    }

    @Nonnull
    public ImmutableMap<String, ConfOption> getOptions() {
        return this._options;
    }

    @Override
    public void addTo(ConfFileNode n) {
        n.addOption(this);
    }

    @Nonnull
    public ImmutableSet<String> getOptionNamesFiltered(@Nonnull Predicate<ConfOption> filter) {
        return FluentIterable.from((Iterable)this._options.values()).filter(filter).transform(ConfOption.GET_OPTION_NAME).toSet();
    }

    @Nonnull
    public ImmutableSet<String> getOptionNames() {
        return this.getOptionNamesFiltered((Predicate<ConfOption>)Predicates.alwaysTrue());
    }
}

