/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileNode;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileSource;
import de.justsoftware.onx.common.business.configfile.parser.ConfigFileLexer;
import de.justsoftware.onx.common.business.configfile.parser.ConfigFileParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfFileUtil.class);
    private static List<File> _searchPaths = new ArrayList<File>();

    public static void addSearchPath(@Nonnull File path) {
        if (!_searchPaths.contains(path)) {
            _searchPaths.add(path);
        }
    }

    @Nonnull
    public static List<URL> getConfigFileUrls(ConfFileSource ... sources) {
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        for (ConfFileSource source : sources) {
            URL configFileUrl = ConfFileUtil.getConfigFileUrl(source.getFileName());
            if (configFileUrl != null) {
                result.add(configFileUrl);
                continue;
            }
            if (!source.isRequired()) continue;
            throw new LoadConfigFileException(String.format("Failed to load required config file '%s'", source.getFileName()));
        }
        return result;
    }

    @CheckForNull
    private static URL getConfigFileUrl(@Nonnull String fileName) throws LoadConfigFileException {
        try {
            URL configFileUrl = ConfFileUtil.class.getClassLoader().getResource(fileName);
            if (configFileUrl == null) {
                configFileUrl = ConfFileUtil.fileToURL(new File(fileName));
            }
            if (configFileUrl == null) {
                File path;
                Iterator<File> iterator = _searchPaths.iterator();
                while (iterator.hasNext() && (configFileUrl = ConfFileUtil.fileToURL(new File(path = iterator.next(), fileName))) == null) {
                }
            }
            return configFileUrl;
        }
        catch (MalformedURLException e) {
            throw new LoadConfigFileException(String.format("Failed to load config file '%s'", fileName), (Throwable)e);
        }
    }

    @Nonnull
    public static ConfFileNode load(@Nonnull String fileName) throws LoadConfigFileException {
        return ConfFileUtil.load(ConfFileUtil.requiredUnwatchedSourceOf(fileName));
    }

    @Nonnull
    @VisibleForTesting
    public static ConfFileNode loadSourceCode(@Nonnull String source) throws LoadConfigFileException {
        return ConfFileUtil.load(ConfFileUtil.fileSourceFromSourceCode(source));
    }

    @Nonnull
    public static ConfFileNode load(ConfFileSource ... sources) throws LoadConfigFileException {
        ConfFileNode c = new ConfFileNode(null);
        List<URL> configFileUrls = ConfFileUtil.getConfigFileUrls(sources);
        for (URL url : configFileUrls) {
            ConfFileUtil.include(url, c, null);
        }
        return c;
    }

    private static URL fileToURL(@Nonnull File file) throws MalformedURLException {
        return file.isFile() ? file.toURI().toURL() : null;
    }

    public static void include(@Nonnull String fileName, @Nonnull ConfFileNode c, @Nonnull ConfFilePosition pos) throws LoadConfigFileException {
        URL configFileUrl = ConfFileUtil.getConfigFileUrl(fileName);
        if (configFileUrl == null) {
            throw new LoadConfigFileException(pos, String.format("Could not find config file '%s'", fileName));
        }
        ConfFileUtil.include(configFileUrl, c, pos);
    }

    private static void include(@Nonnull URL configFileUrl, @Nonnull ConfFileNode c, @Nullable ConfFilePosition pos) throws LoadConfigFileException {
        try {
            LOG.info("Loading config file " + configFileUrl.getFile());
            URLConnection configFileConn = configFileUrl.openConnection();
            configFileConn.setUseCaches(false);
            InputStream is = configFileConn.getInputStream();
            ConfFileUtil.include(configFileUrl.toString(), is, c, pos);
        }
        catch (IOException e) {
            LOG.error("ERROR while loading config file " + configFileUrl.getFile(), (Throwable)e);
            throw new LoadConfigFileException(pos, e.getMessage(), e);
        }
    }

    @VisibleForTesting
    public static void include(@Nonnull String inputName, @Nonnull InputStream is, @Nonnull ConfFileNode c, @Nullable ConfFilePosition pos) throws LoadConfigFileException {
        try {
            ANTLRInputStream stream = new ANTLRInputStream(is);
            stream.name = inputName;
            ConfigFileLexer lex = new ConfigFileLexer((CharStream)stream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            ConfigFileParser g = new ConfigFileParser((TokenStream)tokens);
            g.config(c);
        }
        catch (IOException e) {
            LOG.error("ERROR while loading config from " + inputName, (Throwable)e);
            throw new LoadConfigFileException(pos, e.getMessage(), e);
        }
        catch (RecognitionException e) {
            throw new LoadConfigFileException(pos, e.getMessage(), e);
        }
    }

    @Nonnull
    public static List<File> getSearchPaths() {
        return _searchPaths;
    }

    public static void setSearchPaths(@Nonnull List<File> searchPaths) {
        _searchPaths = searchPaths;
    }

    @Nonnull
    public static ConfFileSource requiredUnwatchedSourceOf(final @Nonnull String fileName) {
        return new ConfFileSource(){

            @Override
            public String getFileName() {
                return fileName;
            }

            @Override
            public boolean isRequired() {
                return true;
            }

            @Override
            public boolean reloadOnChange() {
                return false;
            }
        };
    }

    @Nonnull
    @VisibleForTesting
    public static ConfFileSource fileSourceFromSourceCode(@Nonnull String sourceCode) throws LoadConfigFileException {
        try {
            final File file = File.createTempFile("configFile", ".cfg");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            out.write(sourceCode);
            IOUtils.closeQuietly((Writer)out);
            return new ConfFileSource(){

                @Override
                public String getFileName() {
                    return file.toString();
                }

                @Override
                public boolean isRequired() {
                    return true;
                }

                @Override
                public boolean reloadOnChange() {
                    return false;
                }
            };
        }
        catch (IOException e) {
            throw new LoadConfigFileException("Could not create temp file", (Throwable)e);
        }
    }
}

