/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.StaticPermissionRole;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.authorization.business.StaticRoles;
import de.justsoftware.onx.common.business.configfile.AbstractConfNode;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.ConfFilePostValidator;
import de.justsoftware.onx.common.business.configfile.ConfNode;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.business.configfile.parser.ConfAction;
import de.justsoftware.onx.common.business.configfile.parser.ConfAuthHierarchy;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentPos;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentPosList;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentType;
import de.justsoftware.onx.common.business.configfile.parser.ConfEntityType;
import de.justsoftware.onx.common.business.configfile.parser.ConfFileImpl;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.business.configfile.parser.ConfPathElement;
import de.justsoftware.onx.common.business.configfile.parser.ConfPersonRole;
import de.justsoftware.onx.common.business.configfile.parser.ConfigurationFor;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathMatcher;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.AuthorityCreator;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypes;
import de.justsoftware.onx.common.shared.util.Enums2;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.right.DynamicRightCreator;
import de.justsoftware.onx.container.shared.model.right.StaticRight;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import de.justsoftware.onx.tasks.authorization.TaskRole;
import de.justsoftware.onx.workstream.business.WorkstreamFilterConfValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ConfFileNode
extends AbstractConfNode {
    public static final ImmutableMap<String, AuthorityCreator> STATIC_ALL_AUTHORITIES = ConfFileNode.createStaticValues();
    public static final String GLOBAL_SETTINGS = "GLOBAL_SETTINGS";
    public static final ImmutableSet<String> IGNORED_WORDS = ImmutableSet.of((Object)"NEWSLETTER", (Object)"ADMIN_SEND_NEWSLETTER_TO_CURRENT_USER", (Object)"ADMIN_REMOVE_OBSOLETE_PERSONS", (Object)"GET_LINK_INFO", (Object)"PERSON_SEE_PRESENCE", (Object)"PROFILE_MODIFY_PRIVACY", (Object[])new String[]{"PROFILE_READ", "ADMIN_GET_CHAT_PASSWORD", "ADMIN_MODIFY_DEFAULT_NAVIGATION", "REPORT_VIOLATION", "PERSON_GREET", "GREETINGS", "ADMIN_EXPORT_MODIFIED_PERSONS", "INVITE_EXTERNAL", "ENTITY_INVITE_EXTERNAL", "NEWSBLOG", "NEWSBLOG_CREATE", "NEWSBLOG_READ", "NEWSBLOG_DELETE", "NEWSBLOG_UPDATE", "NEWSBLOG_ARTICLE", "NEWSBLOG_ARTICLE_AUTHOR", "ADMIN_IMPORT_I18N", "ADMIN_EXPORT_I18N", "ADMIN_SUPEROPERTY_TRANSLATION_EDIT"});
    private static final ImmutableSet<String> FORBIDDEN_ENTITY_TYPE_NAMES = ImmutableSet.of((Object)"PROFILE", (Object)"ALL_ENTITIES", (Object)"ALL");
    private static final ImmutableList<ConfFilePostValidator> POST_VALIDATORS = ImmutableList.of((Object)WorkstreamFilterConfValidator.INSTANCE);
    private static final ImmutableSet<String> FORBIDDEN_ROLE_NAMES = ImmutableSet.builder().add((Object[])new String[]{"TRUE", "FALSE", "and", "or", "not", "null"}).addAll((Iterable)FluentIterable.from(StaticRoles.VALUES).transform(StaticRole.TO_NAME)).addAll((Iterable)FluentIterable.from((Object[])StaticRight.values()).transform(StaticRight.TO_NAME)).addAll((Iterable)FluentIterable.from((Object[])DynamicRightCreator.values()).transform(DynamicRightCreator.TO_NAME)).build();
    private static final Logger LOG = LoggerFactory.getLogger(ConfFileNode.class);
    private final List<ConfAction> _actions = Lists.newLinkedList();
    private final List<ConfAuthHierarchy> _authHierarchies = Lists.newLinkedList();
    private final List<ConfOptionsFor> _optionsFor = Lists.newLinkedList();
    private final List<ConfComponentPosList> _componentPosList = Lists.newLinkedList();
    private final List<ConfigurationFor> _configurationFor = Lists.newLinkedList();
    private final List<ConfEntityType> _entityTypes = Lists.newLinkedList();
    private final List<ConfPersonRole> _personRoles = Lists.newLinkedList();

    public ConfFileNode(@Nullable ConfFilePosition pos) {
        super(pos);
    }

    @Nonnull
    private static ImmutableMap<String, AuthorityCreator> createStaticValues() {
        ImmutableMap.Builder all = ImmutableMap.builder();
        ConfFileNode.addAllEnumValues((ImmutableMap.Builder<String, AuthorityCreator>)all, StaticRight.class);
        ConfFileNode.addAllEnumValues((ImmutableMap.Builder<String, AuthorityCreator>)all, DynamicRightCreator.class);
        ConfFileNode.addAllEnumValues((ImmutableMap.Builder<String, AuthorityCreator>)all, StaticPredefinedRole.class);
        ConfFileNode.addAllEnumValues((ImmutableMap.Builder<String, AuthorityCreator>)all, TaskRole.class);
        ConfFileNode.addAllEnumValues((ImmutableMap.Builder<String, AuthorityCreator>)all, StaticPermissionRole.class);
        return all.build();
    }

    private static <E extends Enum<?>> void addAllEnumValues(ImmutableMap.Builder<String, AuthorityCreator> builder, Class<E> clz) {
        for (Enum authorityCreator : (Enum[])clz.getEnumConstants()) {
            builder.put((Object)authorityCreator.getName(), (Object)authorityCreator);
        }
    }

    public void addAction(ConfAction confAction) {
        this._actions.add(confAction);
    }

    @Nonnull
    public List<ConfAction> getActions() {
        return this._actions;
    }

    public void addAuthHierarchy(ConfAuthHierarchy confAuthHierarchy) {
        this._authHierarchies.add(confAuthHierarchy);
    }

    @Nonnull
    public List<ConfAuthHierarchy> getAuthHierarchies() {
        return this._authHierarchies;
    }

    public void addOption(ConfOptionsFor confOptionsFor) {
        this._optionsFor.add(confOptionsFor);
    }

    public void addFacilities(ConfigurationFor facilitiesFor) {
        this._configurationFor.add(facilitiesFor);
    }

    @Nonnull
    public List<ConfOptionsFor> getOptionsFor() {
        return this._optionsFor;
    }

    @Nonnull
    public List<ConfigurationFor> getConfigurationFor() {
        return this._configurationFor;
    }

    public void addComponentPosList(ConfComponentPosList confComponentPosList) {
        this._componentPosList.add(confComponentPosList);
    }

    @Nonnull
    public List<ConfComponentPosList> getComponentPosList() {
        return this._componentPosList;
    }

    @Nonnull
    private ImmutableSetMultimap<Authority, Authority> extractAuthorityIsA(Map<String, AuthorityCreator> authorities) throws LoadConfigFileException {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (ConfAuthHierarchy h : this.getAuthHierarchies()) {
            try {
                Authority a = AuthorityUtil.valueOf(authorities, h.getNameAndParam());
                for (NameAndParam is : h.getIsNameParam()) {
                    if (!IGNORED_WORDS.contains((Object)is.getName())) {
                        result.put((Object)a, (Object)AuthorityUtil.valueOf(authorities, is));
                        continue;
                    }
                    LOG.warn("config contains deprecated option {}", (Object)is.getName());
                }
            }
            catch (IllegalArgumentException e) {
                throw new LoadConfigFileException(h.getPos(), e.toString(), e);
            }
        }
        return result.build();
    }

    @Nonnull
    private Map<NameAndParam, BoolExpr> extractAuthoritySubstitude(ImmutableSetMultimap<Authority, Authority> replacements) {
        ImmutableSetMultimap inverted = replacements.inverse();
        ImmutableMap.Builder authoritySubstitude = ImmutableMap.builder();
        for (Authority a : inverted.keySet()) {
            HashSet or = Sets.newHashSet();
            LinkedList q = Lists.newLinkedList();
            q.add(a);
            Authority b = (Authority)q.poll();
            while (b != null) {
                if (or.add(BoolExpr.var(b.getNameAndParam()))) {
                    q.addAll(inverted.get((Object)b));
                }
                b = (Authority)q.poll();
            }
            authoritySubstitude.put((Object)a.getNameAndParam(), (Object)BoolExpr.or(or));
        }
        return authoritySubstitude.build();
    }

    private static <T extends ConfNode, O> void checkList(Iterable<T> listToCheck, Function<? super T, O> transform, Set<? extends O> forbidden, String msg) {
        for (ConfNode t : listToCheck) {
            Object o = transform.apply((Object)t);
            if (!forbidden.contains(o)) continue;
            throw new LoadConfigFileException(t.getPos(), String.format(msg, o));
        }
    }

    private void checkEntityTypes() throws LoadConfigFileException {
        ConfFileNode.checkList(this._entityTypes, Functions.compose(EntityType.TO_NAME, ConfEntityType.GET_ENTITY_TYPE), FORBIDDEN_ENTITY_TYPE_NAMES, "You may not use '%s' for an entity type name.");
    }

    private void checkPersonRoles() {
        ConfFileNode.checkList(this._personRoles, Functions.compose(Role.TO_NAME, ConfPersonRole::getRole), FORBIDDEN_ROLE_NAMES, "You may not use '%s' for a role name.");
        for (ConfPersonRole role : this._personRoles) {
            String roleName = role.getRole().getName();
            if (roleName.length() <= 15) continue;
            throw new LoadConfigFileException(role.getPos(), "person role \"" + roleName + "\" is too long, a role should have at most 15 characters");
        }
    }

    @Nonnull
    public ConfFile checkAndAnalyze(boolean failOnMissingAuthorities) throws LoadConfigFileException {
        HashMap authorities = Maps.newHashMap(STATIC_ALL_AUTHORITIES);
        ImmutableSet<PersonRole> personRoles = this.getAllPersonRoles();
        for (PersonRole role : personRoles) {
            authorities.put(role.getName(), role);
        }
        ImmutableSetMultimap<Authority, Authority> replacements = this.extractAuthorityIsA(authorities);
        Map<NameAndParam, BoolExpr> authoritySubstitude = this.extractAuthoritySubstitude(replacements);
        Set<String> authorityNames = authorities.keySet();
        HashSet<String> items = new HashSet<String>();
        HashSet<String> itemsAndActions = new HashSet<String>();
        HashSet<String> itemsAndComponents = new HashSet<String>();
        HashSet<String> itemsComponentAndRights = new HashSet<String>();
        for (ItemType i : ItemType.values()) {
            items.add(i.name());
            itemsAndActions.add(i.name());
            itemsComponentAndRights.add(i.name());
            itemsAndComponents.add(i.name());
        }
        ImmutableSet.Builder actionBuilder = ImmutableSet.builder();
        actionBuilder.add((Object[])StaticAction.values());
        actionBuilder.add((Object[])StaticEntityAction.values());
        actionBuilder.add((Object[])StaticItemAction.values());
        actionBuilder.add((Object[])DynamicActionCreator.values());
        actionBuilder.add((Object[])TaskAction.values());
        actionBuilder.add((Object[])StaticPermissionAction.values());
        itemsAndActions.addAll((Collection<String>)FluentIterable.from((Iterable)actionBuilder.build()).transform(Enums2.NAME).toSet());
        itemsAndComponents.addAll((Collection<String>)ComponentTypes.allCreatorNames());
        itemsComponentAndRights.addAll((Collection<String>)ComponentTypes.allCreatorNames());
        for (StaticRight r : StaticRight.values()) {
            itemsComponentAndRights.add(r.getName());
        }
        for (Enum d : DynamicRightCreator.values()) {
            itemsComponentAndRights.add(((DynamicRightCreator)d).getName());
        }
        PathMatcher<BoolExpr, ImmutableBoolContext> actions = this.getActions(authoritySubstitude, authorityNames, itemsAndActions, failOnMissingAuthorities);
        PathMatcher<ConfOptionsFor, ImmutableBoolContext> optionsFor = this.getOptionsFor(authoritySubstitude, authorityNames, itemsComponentAndRights, failOnMissingAuthorities);
        PathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext> componentPositions = this.getComponentPositions(items);
        PathMatcher<ConfigurationFor, ImmutableBoolContext> configurationFor = this.getConfiguration(itemsAndComponents);
        ImmutableListMultimap<OptionName<?>, Object> allConfigurations = this.getAllConfigurations();
        ConfFileImpl result = new ConfFileImpl(actions, optionsFor, componentPositions, configurationFor, this.getEntityTypes(), allConfigurations, personRoles, this.getHiddenPersonRoles(), this.getAllAuthorities());
        this.postValidate(result);
        return result;
    }

    @Nonnull
    private ImmutableSet<NameAndParam> getAllAuthorities() {
        FluentIterable boolExprsFromActions = FluentIterable.from(this._actions).transform(ConfAction.GET_EXPR);
        return FluentIterable.from(this._optionsFor).transformAndConcat(ConfOptionsFor.GET_CONF_OPTIONS).transform(ConfOption.GET_EXPR).append((Iterable)boolExprsFromActions).transformAndConcat(BoolExpr.GET_USED_VARIABLES).toSet();
    }

    private void postValidate(ConfFile confFile) {
        for (ConfFilePostValidator v : POST_VALIDATORS) {
            v.validate(confFile);
        }
    }

    private static void checkAllowedWords(Set<String> allowedWords, List<? extends ConfPathElement> path) {
        for (ConfPathElement confPathElement : path) {
            ConfFileNode.checkAllowedWord(allowedWords, confPathElement);
        }
    }

    private static void checkAllowedWord(Set<String> allowedWords, ConfPathElement pathElement) {
        String word;
        switch (word = pathElement.getWord()) {
            case "": 
            case "*": 
            case "**": {
                return;
            }
        }
        if (!allowedWords.contains(word)) {
            if (IGNORED_WORDS.contains((Object)word)) {
                LOG.info(pathElement.getPos() + "The value \"" + word + "\" is deprecated and ignored. Please remove this value from configuration.");
                return;
            }
            throw new LoadConfigFileException(pathElement.getPos(), "forbidden word " + word + " found, allowed words are " + allowedWords);
        }
    }

    @Nonnull
    private PathMatcher<BoolExpr, ImmutableBoolContext> getActions(Map<NameAndParam, BoolExpr> authoritySubstitude, Set<String> authorityNames, Set<String> itemsAndActions, boolean failOnMissingAuthorities) {
        PathMatcher.ReversedPathMatcher<BoolExpr, ImmutableBoolContext> actions = new PathMatcher.ReversedPathMatcher<BoolExpr, ImmutableBoolContext>();
        for (ConfAction a : this.getActions()) {
            if (failOnMissingAuthorities) {
                a.getExpr().checkVariables(authorityNames);
            }
            ConfFileNode.checkAllowedWords(itemsAndActions, a.getPath());
            actions.add(a.getPath(), a.getExpr().substitute(authoritySubstitude).simplify());
        }
        return actions;
    }

    @Nonnull
    private PathMatcher<ConfOptionsFor, ImmutableBoolContext> getOptionsFor(Map<NameAndParam, BoolExpr> authoritySubstitude, Set<String> authorityNames, Set<String> itemsComponentAndRights, boolean failOnMissingAuthorities) {
        PathMatcher.ReversedPathMatcher<ConfOptionsFor, ImmutableBoolContext> optionsFor = new PathMatcher.ReversedPathMatcher<ConfOptionsFor, ImmutableBoolContext>();
        for (ConfOptionsFor os : this.getOptionsFor()) {
            for (ConfOption o : os.getOptions().values()) {
                if (failOnMissingAuthorities) {
                    o.getExpr().checkVariables(authorityNames);
                }
                o.setExpr(o.getExpr().substitute(authoritySubstitude).simplify());
            }
            ConfFileNode.checkAllowedWords(itemsComponentAndRights, os.getPath());
            optionsFor.add(os.getPath(), os);
        }
        return optionsFor;
    }

    @Nonnull
    private PathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext> getComponentPositions(Set<String> items) {
        PathMatcher.ReversedPathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext> componentPositions = new PathMatcher.ReversedPathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext>();
        for (ConfComponentPosList l : this.getComponentPosList()) {
            ImmutableListMultimap.Builder components = ImmutableListMultimap.builder();
            HashSet<ComponentType> used = new HashSet<ComponentType>();
            for (ConfComponentPos confPos : l.getComponentPos()) {
                for (ConfComponentType confComponentType : confPos.getComponentTypes()) {
                    ComponentType componentType = confComponentType.getComponentType();
                    if (!used.add(componentType)) {
                        throw new LoadConfigFileException(l.getPos(), "the component type " + componentType + " is used multiple which is not allowed");
                    }
                    components.putAll((Object)confPos.getComponentPosition(), (Object[])new ConfComponentType[]{confComponentType});
                }
            }
            ConfFileNode.checkAllowedWords(items, l.getPath());
            componentPositions.add(l.getPath(), (ImmutableListMultimap<ComponentPosition, ConfComponentType>)components.build());
        }
        return componentPositions;
    }

    @Nonnull
    private PathMatcher<ConfigurationFor, ImmutableBoolContext> getConfiguration(Set<String> items) {
        ImmutableSet words = ImmutableSet.builder().addAll(items).add((Object)GLOBAL_SETTINGS).build();
        PathMatcher.ReversedPathMatcher<ConfigurationFor, ImmutableBoolContext> entityConfiguration = new PathMatcher.ReversedPathMatcher<ConfigurationFor, ImmutableBoolContext>();
        for (ConfigurationFor f : this.getConfigurationFor()) {
            ConfFileNode.checkAllowedWords((Set<String>)words, f.getPath());
            entityConfiguration.add(f.getPath(), f);
        }
        return entityConfiguration;
    }

    @Nonnull
    private ImmutableListMultimap<OptionName<?>, Object> getAllConfigurations() {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (ConfigurationFor f : this.getConfigurationFor()) {
            result.putAll((Multimap)Multimaps.forMap(f.getOptions()));
        }
        return result.build();
    }

    public void addEntityType(ConfEntityType entityType) {
        this._entityTypes.removeAll((Collection<?>)ImmutableSet.of((Object)entityType));
        this._entityTypes.add(entityType);
    }

    @Nonnull
    @VisibleForTesting
    ImmutableSet<EntityType> getEntityTypes() {
        this.checkEntityTypes();
        return FluentIterable.from(this._entityTypes).transform(ConfEntityType.GET_ENTITY_TYPE).toSet();
    }

    public void addPersonRole(ConfPersonRole role) {
        this._personRoles.removeAll((Collection<?>)ImmutableSet.of((Object)role));
        this._personRoles.add(role);
    }

    @Nonnull
    @VisibleForTesting
    ImmutableSet<PersonRole> getAllPersonRoles() {
        this.checkPersonRoles();
        return FluentIterable.from(this._personRoles).transform(ConfPersonRole::getRole).toSet();
    }

    @Nonnull
    @VisibleForTesting
    ImmutableSet<PersonRole> getHiddenPersonRoles() {
        this.checkPersonRoles();
        return FluentIterable.from(this._personRoles).filter(ConfPersonRole::isHidden).transform(ConfPersonRole::getRole).toSet();
    }
}

