/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.boolexpr.AbstractSubstituteBoolExprVisitor;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.ImmutableBoolContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.VarExpr;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentType;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.business.configfile.parser.ConfigurationFor;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathMatchElement;
import de.justsoftware.onx.common.business.configfile.pathmatcher.PathMatcher;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class ConfFileImpl
implements ConfFile {
    private static final Object NULL = new Object();
    private static final ConfOptionsFor DEFAULT_OPTIONS_FOR = new ConfOptionsFor(null, Collections.emptyList(), (Iterable<ConfOption>)ImmutableList.of());
    private final PathMatcher<BoolExpr, ImmutableBoolContext> _actions;
    private final PathMatcher<ConfOptionsFor, ImmutableBoolContext> _optionsFor;
    private final PathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext> _componentPositions;
    private final PathMatcher<ConfigurationFor, ImmutableBoolContext> _configurationFor;
    private final ImmutableSet<EntityType> _entityTypes;
    private final ImmutableListMultimap<OptionName<?>, Object> _allConfigurations;
    private final ImmutableSet<PersonRole> _allPersonRoles;
    private final ImmutableSet<PersonRole> _hiddenPersonRoles;
    private final ImmutableSet<NameAndParam> _allAuthorities;
    private final Map<Object, Object> _cache = Maps.newConcurrentMap();

    ConfFileImpl(PathMatcher<BoolExpr, ImmutableBoolContext> actions, PathMatcher<ConfOptionsFor, ImmutableBoolContext> optionsFor, PathMatcher<ImmutableListMultimap<ComponentPosition, ConfComponentType>, ImmutableBoolContext> componentPositions, PathMatcher<ConfigurationFor, ImmutableBoolContext> configurationFor, ImmutableSet<EntityType> entityTypes, ImmutableListMultimap<OptionName<?>, Object> allConfigurations, ImmutableSet<PersonRole> allPersonRoles, ImmutableSet<PersonRole> hiddenPersonRoles, ImmutableSet<NameAndParam> allAuthorities) {
        this._actions = actions;
        this._optionsFor = optionsFor;
        this._componentPositions = componentPositions;
        this._configurationFor = configurationFor;
        this._entityTypes = entityTypes;
        this._allConfigurations = allConfigurations;
        this._allPersonRoles = allPersonRoles;
        this._hiddenPersonRoles = hiddenPersonRoles;
        this._allAuthorities = allAuthorities;
    }

    @Override
    public BoolExpr getAction(Path path) {
        BoolExpr orgExpr = this._actions.get((List<PathMatchElement<ImmutableBoolContext>>)path.getPath()).orElse(BoolExpr.FALSE);
        return orgExpr.accept(new PlaceholderSubstituteBoolExprVisitor(path.getActionParameter()));
    }

    @Override
    public boolean isActionPathDefined(Path path) {
        return !this._actions.getAllMatches((List<PathMatchElement<ImmutableBoolContext>>)path.getPath()).isEmpty();
    }

    @Override
    public ConfOptionsFor getConfOption(Path path) {
        return this._optionsFor.get((List<PathMatchElement<ImmutableBoolContext>>)path.getPath()).orElse(DEFAULT_OPTIONS_FOR);
    }

    @Override
    public ListMultimap<ComponentPosition, ConfComponentType> getComponentPosition(Path path) {
        return (ListMultimap)this._componentPositions.get((List<PathMatchElement<ImmutableBoolContext>>)path.getPath()).orElse((ImmutableListMultimap<ComponentPosition, ConfComponentType>)ImmutableListMultimap.of());
    }

    @Override
    public <T> T getConfigurationFor(Path path, OptionName<T> optionName, T defaultValue) {
        T result = this.cachedConfigurationFor(path, optionName);
        return result != null ? result : defaultValue;
    }

    @Override
    public <T> Iterable<T> getAllConfigurationsFor(Path path, OptionName<T> optionName) {
        List<ConfigurationFor> matches = this._configurationFor.getAllMatches((List<PathMatchElement<ImmutableBoolContext>>)path.getPath());
        ImmutableList.Builder result = ImmutableList.builder();
        for (ConfigurationFor m : matches) {
            T t = m.getOption(optionName);
            if (t == null) continue;
            result.add(t);
        }
        return result.build();
    }

    @Override
    public <T> ImmutableList<T> getAllConfigurationsForOption(OptionName<T> optionName) {
        ImmutableList result = this._allConfigurations.get(optionName);
        return result;
    }

    @CheckForNull
    private <T> T cachedConfigurationFor(Path path, OptionName<T> optionName) {
        ImmutableList<PathMatchElement<ImmutableBoolContext>> pathElements = path.getPath();
        ImmutableList key = ImmutableList.builder().add(optionName).addAll(pathElements).build();
        Object cached = this._cache.get(key);
        if (cached != null) {
            if (cached == NULL) {
                return null;
            }
            Object casted = cached;
            return (T)casted;
        }
        List<ConfigurationFor> matches = this._configurationFor.getAllMatches((List<PathMatchElement<ImmutableBoolContext>>)pathElements);
        for (ConfigurationFor c : Lists.reverse(matches)) {
            T v = c.getOption(optionName);
            if (v == null) continue;
            this._cache.put(key, v);
            return v;
        }
        this._cache.put(key, NULL);
        return null;
    }

    @Override
    public ImmutableSet<EntityType> getEntityTypes() {
        return this._entityTypes;
    }

    @Override
    public ImmutableSet<PersonRole> getAllPersonRoles() {
        return this._allPersonRoles;
    }

    @Override
    public ImmutableSet<PersonRole> getHiddenPersonRoles() {
        return this._hiddenPersonRoles;
    }

    @Override
    public ImmutableSet<NameAndParam> getAllAuthorities() {
        return this._allAuthorities;
    }

    private static class PlaceholderSubstituteBoolExprVisitor
    extends AbstractSubstituteBoolExprVisitor {
        private final String _actionParam;

        public PlaceholderSubstituteBoolExprVisitor(@Nullable String actionParam) {
            this._actionParam = actionParam;
        }

        @Override
        public BoolExpr visit(VarExpr expr) {
            return "_".equals(expr.getVarName().getParam()) ? BoolExpr.var(expr.getPos(), expr.getVarName().getName(), this._actionParam) : expr;
        }
    }
}

