/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.nodes;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.common.business.configfile.AbstractConfJsonNode;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.container.business.OptionType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NumberNode
extends AbstractConfJsonNode {
    private final BigDecimal _value;

    public NumberNode(@Nullable ConfFilePosition pos, BigDecimal value) {
        super(pos);
        this._value = value;
    }

    public NumberNode(@Nullable ConfFilePosition pos, @Nonnull String value) {
        this(pos, new BigDecimal(value));
    }

    @Nonnull
    @VisibleForTesting
    public static NumberNode create(String value) {
        return new NumberNode(null, value);
    }

    public BigDecimal getValue() {
        return this._value;
    }

    @Override
    public NumberNode assertNumber() throws OptionType.OptionTypeException {
        return this;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof NumberNode && this._value.equals(((NumberNode)obj)._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

