/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.ProfileConfigService;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponentConf;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageImagePresentationType;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="profileConfigService")
public class ProfileConfigServiceImpl
implements ProfileConfigService {
    @Autowired
    private ConfigFileService _configFileService;

    private boolean boolConfByPerson(@Nonnull OptionName<Boolean> optionName, @Nonnull Set<PersonRole> roles) {
        return this._configFileService.getConfigFile().getConfigurationFor(Path.builder().addProfile(roles).build(), optionName);
    }

    @Override
    public boolean emailNotificationConcernMeDefault(Set<PersonRole> roles) {
        return this.boolConfByPerson(OptionName.EMAIL_NOTIFICATION_CONCERN_ME_DEFAULT, roles);
    }

    @Override
    public boolean emailNotificationConcernMeVisible(Set<PersonRole> roles) {
        return this.boolConfByPerson(OptionName.EMAIL_NOTIFICATION_CONCERN_ME_VISIBLE, roles);
    }

    @Override
    public WorkstreamMessageImagePresentationType getWorkstreamMessageImagePresentationType() {
        return this._configFileService.getConfigFile().getConfigurationFor(Path.ANY_PROFILE, OptionName.WORKSTREAM_MESSAGE_IMAGE_PRESENTATION_TYPE);
    }

    @Override
    public ImmutableListMultimap<ComponentPosition, StartpageComponentConf> getStartpageComponentConf() {
        return this._configFileService.getConfigFile().getConfigurationFor(Path.ANY_STARTPAGE, OptionName.STARTPAGE_COMPONENTS);
    }

    @Override
    public ImmutableSet<PersonRole> getDefaultPersonRoles() {
        return this._configFileService.getConfigFile().getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.DEFAULT_PERSON_ROLES);
    }
}

