/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.ConstExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.model.EntityVersionReviewerConfigModel;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.EntityVersionReviewerConfig;
import de.justsoftware.onx.common.shared.model.JucoIconTypeImpl;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.container.business.EntityStatusReadWriteDataService;
import de.justsoftware.onx.container.business.EntityVersionReadWriteDataService;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityInheritValue;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.model.right.StaticRight;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiTocType;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageImagePresentationType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="entityConfigService")
public class EntityConfigServiceImpl
implements ServerEventHandler,
EntityConfigService {
    private static final String DEFAULT_STATUS_NAME = "DEFAULT";
    private static final Logger LOG = LoggerFactory.getLogger(EntityConfigServiceImpl.class);
    private final ConfigFileService _configFileService;
    private final Settings _settings;
    private final Predicate<EntityType> _entityTypeActivated = new Predicate<EntityType>(){

        public boolean apply(EntityType input) {
            return input != null && EntityConfigServiceImpl.this.boolConfByEntityType(OptionName.ENTITY_TYPE_ACTIVATED, input);
        }
    };
    private final PersonRoleService _personRoleService;
    @Autowired
    private EntityStatusReadWriteDataService _entityStatusReadWriteDataService;
    @Autowired
    private EntityVersionReadWriteDataService _entityVersionReadWriteDataService;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityConfigServiceImpl(ConfigFileService configFileService, PersonRoleService personRoleService, Settings settings) {
        this._configFileService = configFileService;
        this._personRoleService = personRoleService;
        this._settings = settings;
    }

    @Nonnull
    private ConfFile getConfigFile() {
        return this._configFileService.getConfigFile();
    }

    @Nonnull
    private <T> T getConfigurationFor(@Nonnull Path path, @Nonnull OptionName<T> optionName) {
        return this.getConfigFile().getConfigurationFor(path, optionName);
    }

    @Override
    public ImmutableSet<EntityType> getOrderedEntityTypes() {
        return this.getConfigFile().getEntityTypes();
    }

    @Override
    public ImmutableSet<EntityType> getOrderedActivatedEntityTypes() {
        return ImmutableSet.copyOf((Collection)Sets.filter(this.getOrderedEntityTypes(), this.entityTypeActivated()));
    }

    @Override
    public boolean entityTypeDefined(EntityType type) {
        return this.getOrderedEntityTypes().contains((Object)type);
    }

    private boolean boolConfByEntityType(@Nonnull OptionName<Boolean> optionName, @Nonnull EntityType entityType) {
        return this.getConfigurationFor(Path.builder().add(entityType).build(), optionName);
    }

    private boolean boolConfByEntityTypes(@Nonnull OptionName<Boolean> optionName, @Nonnull EntityType parentType, @Nonnull EntityType childType) {
        return this.getConfigurationFor(Path.builder().add(parentType).add(childType).build(), optionName);
    }

    private int intConfByEntityTypes(@Nonnull OptionName<Long> optionName, @Nonnull EntityType parentType, @Nonnull EntityType childType) {
        return this.getConfigurationFor(Path.builder().add(parentType).add(childType).build(), optionName).intValue();
    }

    private int intConfByEntityType(@Nonnull OptionName<Long> optionName, @Nonnull EntityType parentType) {
        return this.getConfigurationFor(Path.builder().add(parentType).build(), optionName).intValue();
    }

    @Nonnull
    private <T> T confByEntityType(@Nonnull OptionName<T> optionName, @Nonnull EntityType entityType) {
        return this.getConfigurationFor(Path.builder().add(entityType).build(), optionName);
    }

    @Override
    public EntityDurationTimeOption getDurationTimeOption(EntityType entityType) {
        return this.confByEntityType(OptionName.DURATION_TIME_OPTION, entityType);
    }

    @Override
    public boolean closingDateActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.CLOSING_DATE_ACTIVATED, entityType);
    }

    @Override
    public boolean freetextLocationActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.FREETEXT_LOCATION_ACTIVATED, entityType);
    }

    @Override
    public boolean linkedEntityRequired(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.LINKED_ENTITY_REQUIRED, entityType);
    }

    @Override
    public boolean notifyMemberOnLocationChangeActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.NOTIFY_MEMBER_ON_LOCATION_CHANGE_ACTIVATED, entityType);
    }

    @Override
    public boolean notifyMemberOnDurationTimeChangeActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.NOTIFY_MEMBER_ON_DURATION_CHANGE_ACTIVATED, entityType);
    }

    @Override
    public boolean notfiyMemberOnDeleteActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.NOTIFY_MEMBER_ON_DELETE_ACTIVATED, entityType);
    }

    @Override
    public boolean logoActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.LOGO_ACTIVATED, entityType);
    }

    @Override
    public boolean iconActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.ICON_ACTIVATED, entityType);
    }

    @Override
    public boolean deleteByAdminActivated(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.DELETE_BY_ADMIN_ACTIVATED, entityType);
    }

    @Override
    public boolean entityTypeActivated(EntityType entityType) {
        return this._entityTypeActivated.apply((Object)entityType);
    }

    @Override
    public Predicate<EntityType> entityTypeActivated() {
        return this._entityTypeActivated;
    }

    @Override
    public boolean displayJoinChildPopupOnJoinEntity(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.DISPLAY_JOIN_CHILD_POPUP_ON_JOIN_ENTITY, entityType);
    }

    @Override
    public boolean showOptionAggregateWorkstream(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_OPTION_AGGREGATE_WORKSTREAM, entityType);
    }

    @Override
    public boolean defaultAggregateWorkstream(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.DEFAULT_AGGREGATE_WORKSTREAM, entityType);
    }

    @Override
    public boolean showOptionStreamWorkstreamToParents(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_OPTION_STREAM_WORKSTREAM_TO_PARENTS, entityType);
    }

    @Override
    public boolean defaultStreamWorkstreamToParents(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.DEFAULT_STREAM_WORKSTREAM_TO_PARENTS, entityType);
    }

    @Override
    public boolean showNumberOfSubscribers(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_NUMBER_OF_SUBSCRIBERS, entityType);
    }

    @Override
    public boolean showTabCounts(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_TAB_COUNTS, entityType);
    }

    @Override
    public boolean showDescriptionInSearchBadge(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_DESCRIPTION_IN_SEARCH_BADGE, entityType);
    }

    @Override
    public TeaserType teaserLeft(EntityType entityType) {
        return this.confByEntityType(OptionName.TEASER_LEFT, entityType);
    }

    @Override
    public TeaserType teaserCenter(EntityType entityType) {
        return this.confByEntityType(OptionName.TEASER_CENTER, entityType);
    }

    @Override
    public TeaserType teaserRight(EntityType entityType) {
        return this.confByEntityType(OptionName.TEASER_RIGHT, entityType);
    }

    @Override
    public boolean leaveAllowed(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.LEAVE_ALLOWED, entityType);
    }

    @Override
    public int minParentCount(EntityType parentType, EntityType childType) {
        return this.intConfByEntityTypes(OptionName.MIN_PARENT_COUNT, parentType, childType);
    }

    @Override
    public int maxParentCount(EntityType parentType, EntityType childType) {
        return this.intConfByEntityTypes(OptionName.MAX_PARENT_COUNT, parentType, childType);
    }

    @Override
    public boolean inheritsMemberEnabled(EntityType parentType, EntityType childType) {
        return this.boolConfByEntityTypes(OptionName.INHERITS_MEMBER_ENABLED, parentType, childType);
    }

    @Override
    public boolean inheritsMemberDefaultValue(EntityType parentType, EntityType childType) {
        return this.boolConfByEntityTypes(OptionName.INHERITS_MEMBER_DEFAULT_VALUE, parentType, childType);
    }

    @Override
    public boolean inheritsAdminEnabled(EntityType parentType, EntityType childType) {
        return this.boolConfByEntityTypes(OptionName.INHERITS_ADMIN_ENABLED, parentType, childType);
    }

    @Override
    public boolean inheritsAdminDefaultValue(EntityType parentType, EntityType childType) {
        return this.boolConfByEntityTypes(OptionName.INHERITS_ADMIN_DEFAULT_VALUE, parentType, childType);
    }

    @Override
    public ImmutableSet<EntityInheritValue> entityInhertitSettings(EntityType parentType, EntityType childType) {
        List l = (List)this.getConfigFile().getConfigurationFor(Path.builder().add(parentType).add(childType).build(), OptionName.ENTITY_INHERIT_SETTINGS);
        ImmutableSet result = ImmutableSet.builder().addAll((Iterable)l).build();
        return result.contains((Object)EntityInheritValue.ALL) ? EntityInheritValue.EVERYTHING : result;
    }

    @Override
    public IconType icon(EntityType entityType) {
        return this.confByEntityType(OptionName.ICON, entityType);
    }

    @Override
    public boolean isIconVisibleOnHeader(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.ICON_VISIBLE_ON_HEADER, entityType);
    }

    @Override
    public boolean releaseProcessMandatory(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.RELEASE_PROCESS_MANDATORY, entityType);
    }

    @Override
    public EntityVersionReleaseDataOption getReleaseActivationDateVisibility(EntityType entityType) {
        return this.confByEntityType(OptionName.RELEASE_ACTIVATION_DATE_VISIBILITY, entityType);
    }

    @Override
    public EntityVersionReleaseDataOption getReleaseExpirationDateVisibility(EntityType entityType) {
        return this.confByEntityType(OptionName.RELEASE_EXPIRATION_DATE_VISIBILITY, entityType);
    }

    @Override
    public EntityVersionReleaseDataOption getReleaseVersionTypeVisibility(EntityType entityType) {
        return this.confByEntityType(OptionName.RELEASE_VERSION_TYPE_VISIBILITY, entityType);
    }

    @Override
    public EntityVersionReleaseDataOption getReleaseChangeMessageVisibility(EntityType entityType) {
        return this.confByEntityType(OptionName.RELEASE_CHANGE_MESSAGE_VISIBILITY, entityType);
    }

    @Override
    public EntityVersionReleaseDataOption getReleaseCommentForReviewerVisibility(EntityType entityType) {
        return this.confByEntityType(OptionName.RELEASE_COMMENT_FOR_REVIEWER_VISIBILITY, entityType);
    }

    @Override
    public boolean isReviewMandatoryForRelease(EntityType entityType) {
        Path path = Path.builder().add(entityType).buildWithAction(StaticEntityAction.ENTITY_BECOME_VERSION_REVIEWER);
        BoolExpr action = this.getConfigFile().getAction(path);
        return !(action instanceof ConstExpr);
    }

    @Override
    public boolean isAuthorChangeableOnRelease(EntityType entityType) {
        Path path = Path.builder().add(entityType).buildWithAction(StaticEntityAction.ENTITY_BECOME_VERSION_AUTHOR);
        BoolExpr action = this.getConfigFile().getAction(path);
        return !(action instanceof ConstExpr);
    }

    @Override
    public int maxDaysAsActiveVersion(EntityType entityType) {
        return this.intConfByEntityType(OptionName.ENTITY_VERSION_MAX_ACTIVE_DAYS, entityType);
    }

    @Override
    public boolean releaseUseTypeAheadForReviewerSelection(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.RELEASE_CHOOSE_REVIEWER_WITH_TYPEAHEAD, entityType);
    }

    @Override
    public int multiWikiMaxSections(EntityType entityType) {
        return this.intConfByEntityType(OptionName.MULTI_WIKI_MAX_SECTIONS, entityType);
    }

    @Override
    public int multiWikiMaxSectionMaxValue() {
        int max = 0;
        for (EntityType t : this.getOrderedEntityTypes()) {
            max = Math.max(max, this.multiWikiMaxSections(t));
        }
        return max;
    }

    @Override
    public MultiWikiTocType multiWikiToc(EntityType entityType) {
        return this.confByEntityType(OptionName.MULTI_WIKI_TOC, entityType);
    }

    @Override
    public boolean tagsEnabled(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.TAGS_ENABLED, entityType);
    }

    @Override
    public ImmutableSet<EntityType> getAllowedChildrenType(final EntityType parentType) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getOrderedEntityTypes(), (Predicate)new Predicate<EntityType>(){

            public boolean apply(EntityType input) {
                return EntityConfigServiceImpl.this.entityTypeActivated(input) && EntityConfigServiceImpl.this.maxParentCount(parentType, input) > 0;
            }
        }));
    }

    @Override
    public ConfOptionsFor getEntityPrivacyOptions(EntityType entityType, Right right) {
        try {
            return this._configFileService.getConfigFile().getConfOption(Path.builder().add(entityType).add(right).build());
        }
        catch (EvalException e) {
            LOG.error("Could not load default component configuration", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Nonnull
    private ImmutableSet<String> getDefaultPrivacyOptionNamesForRight(@Nonnull EntityType type, @Nonnull Right right) {
        ConfOptionsFor privacyOptionsForRight = this.getEntityPrivacyOptions(type, right);
        return privacyOptionsForRight.getOptionNamesFiltered(ConfOption.IS_DEFAULT);
    }

    @Nonnull
    private ImmutableList<AuthorityModel> getPrivacyOptionNamesForRight(@Nonnull EntityType type, @Nonnull Right right) {
        return FluentIterable.from((Iterable)this.getEntityPrivacyOptions(type, right).getOptions().values()).transform(ConfOption.GET_AUTHORITY_MODEL).toList();
    }

    @Override
    public ImmutableListMultimap<DBPrivacyType, AuthorityModel> getAllAvailableRuleAuthNames(EntityType entityType) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (DBPrivacyType dbPrivacyType : DBPrivacyType.values()) {
            result.putAll((Object)dbPrivacyType, this.getAvailableRuleAuthNames(entityType, dbPrivacyType));
        }
        return result.build();
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableRuleAuthNames(EntityType entityType, DBPrivacyType dbPrivacyType) {
        return this.getPrivacyOptionNamesForRight(entityType, dbPrivacyType.getRight());
    }

    @Override
    public ImmutableSet<String> getDefaultVisibilityRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_READ);
    }

    @Override
    public ImmutableSet<String> getDefaultJoiningRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.JOIN);
    }

    @Override
    public ImmutableSet<String> getDefaultInvitingRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.INVITE);
    }

    @Override
    public ImmutableSet<String> getDefaultNewsletterRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_SEND_NEWSLETTER);
    }

    @Override
    public ImmutableSet<String> getDefaultSendJoinRequestAllowedRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.JOIN_REQUEST);
    }

    @Override
    public ImmutableSet<String> getDefaultModifyTitleRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_MODIFY_TITLE);
    }

    @Override
    public ImmutableSet<String> getDefaultEditEntityRuleAuthNames(EntityType entityType) {
        return this.getDefaultPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_EDIT);
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableSendJoinRequestAllowedRuleAuthNames(EntityType entityType) {
        return this.getPrivacyOptionNamesForRight(entityType, StaticRight.JOIN_REQUEST);
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableVisibilityRuleAuthNames(EntityType entityType) {
        return this.getPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_READ);
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableJoiningRuleAuthNames(EntityType entityType) {
        return this.getPrivacyOptionNamesForRight(entityType, StaticRight.JOIN);
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableInvitingRuleAuthNames(EntityType entityType) {
        return this.getPrivacyOptionNamesForRight(entityType, StaticRight.INVITE);
    }

    @Override
    public ImmutableList<AuthorityModel> getAvailableNewsletterRuleAuthNames(EntityType entityType) {
        return this.getPrivacyOptionNamesForRight(entityType, StaticRight.ENTITY_SEND_NEWSLETTER);
    }

    @Override
    public boolean enableBrowserSearch(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.ENABLE_BROWSER_SEARCH, entityType);
    }

    @Override
    public ImmutableList<DynamicAttributeConfig> getDynamicAttributesForType(EntityType entityType) {
        return this.confByEntityType(OptionName.ENTITY_DYNAMIC_ATTRIBUTES, entityType);
    }

    @Override
    public ImmutableListMultimap<EntityType, DynamicAttributeConfig> getDynamicAttributeConfigs(Set<EntityType> entityTypes) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (EntityType entityType : entityTypes) {
            result.putAll((Object)entityType, this.getDynamicAttributesForType(entityType));
        }
        return result.build();
    }

    @Override
    public ImmutableSetMultimap<EntityType, DynamicAttributeConfig> getSearchableDynamicAttributes() {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.filterValues(this.getDynamicAttributeConfigs((Set<EntityType>)this.getOrderedEntityTypes()), DynamicAttributeConfig.IS_SEARCHABLE));
    }

    @Override
    public ImmutableSet<DynamicAttributeConfig> getFacettableDynamicAttributesForType(EntityType entityType) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getDynamicAttributesForType(entityType), DynamicAttributeConfig.IS_FACETTING_ENABLED));
    }

    @Override
    public ImmutableSetMultimap<EntityType, DynamicAttributeConfig> getFacettableDynamicAttributes() {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.filterValues(this.getDynamicAttributeConfigs((Set<EntityType>)this.getOrderedEntityTypes()), DynamicAttributeConfig.IS_FACETTING_ENABLED));
    }

    @Override
    public ImmutableSet<EntityType> getSuggestParentsForTypes(EntityType entityType) {
        return this._configFileService.getConfigFile().getConfigurationFor(Path.builder().add(entityType).build(), OptionName.ENTITY_SUGGEST_PARENTS_FOR_TYPES);
    }

    @Subscribe
    public void onConfigChange(@Nonnull ConfigFileChangeEvent event) {
        this.initDefaultStatusForConfiguredEntityTypes();
    }

    @Override
    public boolean isAddContentButtonEnabled(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.ADD_CONTENT_BUTTON_ENABLED, entityType);
    }

    @Override
    public ImmutableSet<EntityType> getVisibleParentAssignmentTypes(EntityType entityType) {
        ImmutableSet<String> types = this.confByEntityType(OptionName.VISIBLE_ENTITY_PARENT_ASSIGNMENT_TYPES, entityType);
        if (types.contains((Object)"ALL")) {
            return ImmutableSet.copyOf(this.getOrderedEntityTypes());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(types, EntityType.FROM_NAME));
    }

    @Override
    public boolean isCheckEntityDuplicateName(EntityType entityType) {
        return this.confByEntityType(OptionName.CHECK_ENTITY_DUPLICATE_NAME, entityType);
    }

    @Override
    public EntityVersionReviewerConfig getVersionReleaseReviewerConfig(EntityType entityType) {
        EntityVersionReviewerConfigModel reviewerConfigModel = this.getConfigurationFor(Path.builder().add(entityType).build(), OptionName.ENTITY_VERSION_REVIEWER_OPTIONS);
        ImmutableList<ImmutableSet<String>> configRoles = reviewerConfigModel.getReviewers();
        Range configRange = reviewerConfigModel.getReviewerRange();
        ImmutableMap<String, ? extends Role> allPersonAndStaticRoles = this._personRoleService.getAllPersonAndStaticRoles();
        ImmutableList.Builder resultRoles = ImmutableList.builder();
        for (ImmutableSet cfgRoleSet : configRoles) {
            ImmutableSet.Builder resultRolesForStage = ImmutableSet.builder();
            for (String cfgRoleName : cfgRoleSet) {
                try {
                    resultRolesForStage.add((Object)AuthorityUtil.valueOf(allPersonAndStaticRoles, cfgRoleName));
                }
                catch (IllegalArgumentException ex) {
                    LOG.warn("Problem converting configured entity version reviewer role", (Throwable)ex);
                }
            }
            resultRoles.add((Object)resultRolesForStage.build());
        }
        return new EntityVersionReviewerConfig(configRange, (ImmutableList<ImmutableSet<Role>>)resultRoles.build());
    }

    @Override
    public boolean isEntityNamePreset(EntityType entityType) {
        return this.confByEntityType(OptionName.ENTITY_NAME_PRESET, entityType);
    }

    @Override
    public WorkstreamMessageImagePresentationType getWorkstreamMessageImagePresentationType(EntityType entityType) {
        return this.confByEntityType(OptionName.WORKSTREAM_MESSAGE_IMAGE_PRESENTATION_TYPE, entityType);
    }

    @Override
    public boolean showArchiveSearchFilter(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_ARCHIVE_SEARCH_FILTER, entityType);
    }

    @Override
    public boolean showEntityStatusSearchFilter(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.SHOW_ENTITY_STATUS_SEARCH_FILTER, entityType);
    }

    @Override
    public boolean showSaveButton(EntityType entityType) {
        return this.boolConfByEntityType(OptionName.ENTITY_SHOW_SAVE_BUTTON, entityType);
    }

    @Override
    public EntityMemberWorkflow getEntityMemberWorkflow(EntityType entityType) {
        return this.confByEntityType(OptionName.ENTITY_MEMBER_WORKFLOW, entityType);
    }

    @Override
    public ImmutableSet<EntityStatus> getAvailableEntityStatus(EntityType type) {
        return this._entityStatusReadWriteDataService.getStatusForEntityType(type);
    }

    @Override
    public EntityStatus getEntityStatusById(EntityStatusId statusId) {
        return (EntityStatus)FluentIterable.from((Iterable)this._entityStatusReadWriteDataService.getStatusForEntityTypes((Set<EntityType>)this.getOrderedActivatedEntityTypes()).values()).firstMatch(Identifiables.idEquals(statusId)).orNull();
    }

    @Override
    public ImmutableSet<EntityStatus> getPublishedEntityStatus() {
        return this.getAllEntityStatusForPredicate(EntityStatus.IS_PUBLISHED);
    }

    @Override
    public ImmutableSet<EntityStatus> getPublishedEntityStatus(EntityType type) {
        return FluentIterable.from(this.getAvailableEntityStatus(type)).filter(EntityStatus.IS_PUBLISHED).toSet();
    }

    @Override
    public ImmutableSet<EntityStatus> getAllEntityStatusForPredicate(Predicate<? super EntityStatus> predicate) {
        return FluentIterable.from((Iterable)this._entityStatusReadWriteDataService.getStatusForEntityTypes((Set<EntityType>)this.getOrderedActivatedEntityTypes()).values()).filter(predicate).toSet();
    }

    @Override
    public ImmutableMap<EntityStatus, BoolExpr> getNeededAuthoritiesForEntityVersionStatus(EntityType type) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet<EntityStatus> statusForType = this.getAvailableEntityStatus(type);
        for (EntityStatus status : statusForType) {
            BoolExpr expr = this._configFileService.getConfigFile().getAction(Path.builder().add(type).add(status).buildWithAction(StaticEntityAction.ENTITY_READ_DETAILS));
            builder.put((Object)status, (Object)expr);
        }
        return builder.build();
    }

    @Override
    public EntityStatus getDefaultStatusForEntityType(EntityType type) {
        return (EntityStatus)this.getOptionalDefaultStatusForType(type).get();
    }

    @Nonnull
    private Optional<EntityStatus> getOptionalDefaultStatusForType(@Nonnull EntityType type) {
        Optional optional = FluentIterable.from(this.getAvailableEntityStatus(type)).filter(EntityStatus.IS_DEFAULT).first();
        return optional;
    }

    @PostConstruct
    private void initDefaultStatusForConfiguredEntityTypes() {
        ImmutableSet<EntityType> entityTypes = this.getOrderedActivatedEntityTypes();
        for (EntityType type : entityTypes) {
            if (this.releaseProcessMandatory(type)) {
                this.createNeededStatusForOldReleaseProcess(type);
                EntityStatus newDefault = this.getDefaultStatusForEntityType(type);
                ImmutableSet statusToDelete = FluentIterable.from(this.getAvailableEntityStatus(type)).filter(s -> !ReleaseProcessStatus.ALL_NAMES.contains((Object)s.getName())).transform(Identifiable::getId).toSet();
                if (statusToDelete.isEmpty()) continue;
                this._entityVersionReadWriteDataService.updateStatusOfVersionsWithStatus((Set<EntityStatusId>)statusToDelete, newDefault);
                this._entityStatusReadWriteDataService.deleteStatus((Set<EntityStatusId>)statusToDelete);
                continue;
            }
            Optional<EntityStatus> optionalStatus = this.getOptionalDefaultStatusForType(type);
            if (optionalStatus.isPresent()) continue;
            DBEntityStatus defaultStatus = new DBEntityStatus();
            defaultStatus.setStatusName(DEFAULT_STATUS_NAME);
            defaultStatus.setDefaultStatus(true);
            defaultStatus.setPublishedStatus(true);
            defaultStatus.setArchivedStatus(false);
            defaultStatus.setIconType(JucoIconTypeImpl.OK.getType());
            defaultStatus.setEntityType(type);
            defaultStatus.setOrder(0);
            this._entityStatusReadWriteDataService.insertStatus(defaultStatus);
        }
    }

    private void createNeededStatusForOldReleaseProcess(@Nonnull EntityType entityType) {
        ImmutableSet existingStatusNames = FluentIterable.from(this.getAvailableEntityStatus(entityType)).transform(EntityStatus.TO_NAME).toSet();
        for (ReleaseProcessStatus staticStatus : ReleaseProcessStatus.values()) {
            if (existingStatusNames.contains((Object)staticStatus.getName())) continue;
            DBEntityStatus status = new DBEntityStatus();
            status.setStatusName(staticStatus.getName());
            status.setDefaultStatus(staticStatus.isDefault());
            status.setPublishedStatus(staticStatus.isPublished());
            status.setArchivedStatus(staticStatus.isArchived());
            status.setIconType(JucoIconTypeImpl.OK.getType());
            status.setEntityType(entityType);
            status.setOrder(staticStatus.ordinal());
            this._entityStatusReadWriteDataService.insertStatus(status);
        }
    }

    @Override
    public ImmutableList<EntityTab> getEntityTabOrderForEntityType(EntityType entityType) {
        return EntityTabUtils.filterInactiveChildEntityTypeTabs(this.getOrderedActivatedEntityTypes(), this.confByEntityType(OptionName.ENTITY_TAB_ORDER, entityType));
    }

    @Override
    public long getEntityTabCountForEntityType(EntityType entityType) {
        return this.confByEntityType(OptionName.ENTITY_TAB_COUNT, entityType);
    }

    @Override
    public ImmutableSet<FilterType> getHierarchyFilterTypes(EntityType entityType) {
        ImmutableSet confByEntityType = this.confByEntityType(OptionName.HIERARCHY_CHILD_FILTER, entityType);
        return !OptionName.DEFAULT_HIERARCHY_CHILD_FILTER.equals(confByEntityType) ? confByEntityType : FluentIterable.from(this.getAllowedChildrenType(entityType)).transform(EntityFilterType.FROM_ENTITY_TYPE).filter(Predicates.notNull()).toSet();
    }

    @Override
    public SortType getNavigatorSortType(EntityType entityType) {
        return this.confByEntityType(OptionName.NAVIGATOR_DEFAULT_SORT_TYPE, entityType);
    }

    @Override
    public boolean isNavigatorSearchable(EntityType entityType) {
        return this.confByEntityType(OptionName.NAVIGATOR_SEARCHABLE, entityType);
    }

    @Override
    public boolean isRedirectToSurveyOnNewMemberEnabled(EntityType entityType) {
        return this.confByEntityType(OptionName.REDIRECT_TO_SURVEY_ON_NEW_MEMBER_ENABLED, entityType);
    }

    @Override
    public boolean isShowSubpagesInContentButtons(EntityType entityType) {
        return this.confByEntityType(OptionName.CONTENT_BUTTONS_SHOW_SUBPAGES, entityType);
    }
}

