/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.business.configfile.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.container.business.OptionName;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="configService")
@ParametersAreNonnullByDefault
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigServiceImpl.class);
    private final ConfigFileService _configFileService;
    private final PersonRoleService _personRoleService;

    @Autowired
    public ConfigServiceImpl(ConfigFileService configFileService, PersonRoleService personRoleService) {
        this._configFileService = configFileService;
        this._personRoleService = personRoleService;
    }

    @Nonnull
    private <T> T getConfigurationFor(Path path, OptionName<T> optionName) {
        return this._configFileService.getConfigFile().getConfigurationFor(path, optionName);
    }

    @Override
    public ImmutableSet<WorkstreamFilterId> getAllWorkstreamFilterIds() {
        ImmutableSet.Builder resultSet = ImmutableSet.builder();
        ImmutableList<WorkstreamFilterListModel> allConfs = this._configFileService.getConfigFile().getAllConfigurationsForOption(OptionName.WORKSTREAM_FILTERS);
        for (WorkstreamFilterListModel filters : allConfs) {
            resultSet.addAll(filters.getFilters().values().stream().map(WorkstreamFilterModel::getId).iterator());
        }
        return resultSet.build();
    }

    @Override
    public ImmutableSet<Role> getWorkstreamPublicRoles() {
        ImmutableList<String> workstreamPublicRoles = this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.WORKSTREAM_PUBLIC_ROLES);
        ImmutableMap<String, ? extends Role> allPersonAndStaticRoles = this._personRoleService.getAllPersonAndStaticRoles();
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (String configRole : workstreamPublicRoles) {
            try {
                res.add((Object)AuthorityUtil.valueOf(allPersonAndStaticRoles, configRole));
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Problem converting configured role", (Throwable)ex);
            }
        }
        return res.build();
    }

    @Override
    public Long getWorkstreamMessageDisplayedLength() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.WORKSTREAM_MESSAGE_DISPLAYED_LENGTH);
    }

    @Override
    public int getCommentsDisplayedLength() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.COMMENTS_DISPLAYED_LENGTH);
    }

    @Override
    public Long getNotificationMessageDisplayedLength() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.NOTIFICATION_MESSAGE_DISPLAYED_LENGTH);
    }

    @Override
    public boolean isCopyAddressIconActivated() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.COPY_ADDRESS_ICON_ACTIVATED);
    }

    @Override
    public boolean useExternalSearchProvider() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.USE_EXTERNAL_SEARCH_PROVIDER);
    }

    @Override
    public WorkstreamFilterListModel getWorkstreamFilters(Item<?> item) {
        if (item == null) {
            return OptionName.WORKSTREAM_FILTERS.getDefaultValue();
        }
        Path p = Path.builder().add(item).build();
        return this.getConfigurationFor(p, OptionName.WORKSTREAM_FILTERS);
    }

    @Override
    public WorkstreamFilterModel getDefaultWorkstreamFilter(Item<?> item) {
        WorkstreamFilterListModel filters = this.getWorkstreamFilters(item);
        return (WorkstreamFilterModel)filters.getFilters().get((Object)filters.getDefaultfilter());
    }

    @Override
    public ImmutableSet<WorkstreamFilterMessageType> getPreventActivityMessageTypes() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.PREVENT_ACTIVITY_MESSAGE_TYPES);
    }

    @Override
    public SearchTextBoxFilterListModel getSearchTextBoxFilters() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.SEARCH_TEXTBOX_FILTER);
    }

    @Override
    public boolean isJucoPrintButtonVisible() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.JUCO_PRINT_BUTTON_VISIBLE);
    }

    @Override
    public boolean isTagsForDocumentsEnabled() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.TAGS_DOCUMENTS_ENABLED);
    }

    @Override
    public String getSocialAppStartToken() {
        return (String)this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.SOCIAL_APP_START_TOKEN).orNull();
    }

    @Override
    public ImmutableSet<ThemeAttributeType> getEditableThemeAttributes() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.EDITABLE_THEME_ATTRIBUTES);
    }

    @Override
    public boolean isHeaderCalendarIconEnabled() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.HEADER_CALENDAR_ICON_ENABLED);
    }

    @Override
    public EntityType getHeaderCalendarEntityType() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.HEADER_CALENDAR_ENTITY_TYPE);
    }

    @Override
    public int getCalendarFeedMaxEventAge() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.CALENDAR_FEED_EVENT_MAX_AGE).intValue();
    }

    @Override
    public String getEditorToolbar() {
        return this.getConfigurationFor(Path.GLOBAL_SETTINGS, OptionName.EDITOR_TOOLBAR);
    }

    @Override
    public boolean isShowPinnedWorkstreamOnStartpage() {
        return this.getConfigurationFor(Path.ANY_STARTPAGE, OptionName.SHOW_PINNED_WORKSTREAM);
    }
}

